/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.ServiceUnavailableRetryStrategy;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.CloseableHttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpExecutionAware;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpRequestWrapper;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.HttpRoute;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.ClientExecChain;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.RequestEntityProxy;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain clientExecChain, ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        Args.notNull(clientExecChain, "HTTP request executor");
        Args.notNull(serviceUnavailableRetryStrategy, "Retry strategy");
        this.requestExecutor = clientExecChain;
        this.retryStrategy = serviceUnavailableRetryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n2 = 1;
        while (true) {
            CloseableHttpResponse closeableHttpResponse = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            try {
                if (this.retryStrategy.retryRequest(closeableHttpResponse, n2, httpClientContext) && RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                    closeableHttpResponse.close();
                    long l2 = this.retryStrategy.getRetryInterval();
                    if (l2 > 0L) {
                        try {
                            this.log.trace("Wait for " + l2);
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return closeableHttpResponse;
                }
                httpRequestWrapper.setHeaders(headerArray);
            }
            catch (RuntimeException runtimeException) {
                closeableHttpResponse.close();
                throw runtimeException;
            }
            ++n2;
        }
    }
}

