/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1;

import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.AttributesImpl;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.Schema;

public class ElementType {
    private String theName;
    private String theNamespace;
    private String theLocalName;
    private int theModel;
    private int theMemberOf;
    private int theFlags;
    private AttributesImpl theAtts;
    private ElementType theParent;
    private Schema theSchema;

    public ElementType(String string, int n2, int n3, int n4, Schema schema) {
        this.theName = string;
        this.theModel = n2;
        this.theMemberOf = n3;
        this.theFlags = n4;
        this.theAtts = new AttributesImpl();
        this.theSchema = schema;
        this.theNamespace = this.namespace(string, false);
        this.theLocalName = this.localName(string);
    }

    public String namespace(String string, boolean bl2) {
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return bl2 ? "" : this.theSchema.getURI();
        }
        String string2 = string.substring(0, n2);
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return new StringBuffer().append("urn:x-prefix:").append(string2).toString().intern();
    }

    public String localName(String string) {
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1).intern();
    }

    public String name() {
        return this.theName;
    }

    public String namespace() {
        return this.theNamespace;
    }

    public String localName() {
        return this.theLocalName;
    }

    public int model() {
        return this.theModel;
    }

    public int memberOf() {
        return this.theMemberOf;
    }

    public int flags() {
        return this.theFlags;
    }

    public AttributesImpl atts() {
        return this.theAtts;
    }

    public ElementType parent() {
        return this.theParent;
    }

    public Schema schema() {
        return this.theSchema;
    }

    public boolean canContain(ElementType elementType) {
        return (this.theModel & elementType.theMemberOf) != 0;
    }

    public void setAttribute(AttributesImpl attributesImpl, String string, String string2, String string3) {
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            return;
        }
        String string4 = this.namespace(string, true);
        String string5 = this.localName(string);
        int n2 = attributesImpl.getIndex(string);
        if (n2 == -1) {
            string = string.intern();
            if (string2 == null) {
                string2 = "CDATA";
            }
            if (!string2.equals("CDATA")) {
                string3 = ElementType.normalize(string3);
            }
            attributesImpl.addAttribute(string4, string5, string, string2, string3);
        } else {
            if (string2 == null) {
                string2 = attributesImpl.getType(n2);
            }
            if (!string2.equals("CDATA")) {
                string3 = ElementType.normalize(string3);
            }
            attributesImpl.setAttribute(n2, string4, string5, string, string2, string3);
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return string;
        }
        if ((string = string.trim()).indexOf("  ") == -1) {
            return string;
        }
        boolean bl2 = false;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ') {
                if (!bl2) {
                    stringBuffer.append(c2);
                }
                bl2 = true;
                continue;
            }
            stringBuffer.append(c2);
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    public void setAttribute(String string, String string2, String string3) {
        this.setAttribute(this.theAtts, string, string2, string3);
    }

    public void setModel(int n2) {
        this.theModel = n2;
    }

    public void setMemberOf(int n2) {
        this.theMemberOf = n2;
    }

    public void setFlags(int n2) {
        this.theFlags = n2;
    }

    public void setParent(ElementType elementType) {
        this.theParent = elementType;
    }
}

