/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private String[] booleans = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    public static final String CDATA_SECTION_ELEMENTS = "cdata-section-elements";
    public static final String DOCTYPE_PUBLIC = "doctype-public";
    public static final String DOCTYPE_SYSTEM = "doctype-system";
    public static final String ENCODING = "encoding";
    public static final String INDENT = "indent";
    public static final String MEDIA_TYPE = "media-type";
    public static final String METHOD = "method";
    public static final String OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String STANDALONE = "standalone";
    public static final String VERSION = "version";
    private Hashtable prefixTable;
    private Hashtable forcedDeclTable;
    private Hashtable doneDeclTable;
    private int elementLevel = 0;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;
    private Properties outputProperties;
    private boolean unicodeMode = false;
    private String outputEncoding = "";
    private boolean htmlMode = false;
    private boolean forceDTD = false;
    private boolean hasOutputDTD = false;
    private String overridePublic = null;
    private String overrideSystem = null;
    private String version = null;
    private String standalone = null;
    private boolean cdataElement = false;

    public XMLWriter() {
        this.init(null);
    }

    public XMLWriter(Writer writer) {
        this.init(writer);
    }

    public XMLWriter(XMLReader xMLReader) {
        super(xMLReader);
        this.init(null);
    }

    public XMLWriter(XMLReader xMLReader, Writer writer) {
        super(xMLReader);
        this.init(writer);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
        this.outputProperties = new Properties();
    }

    public void reset() {
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String string, String string2) {
        this.prefixTable.put(string, string2);
    }

    public String getPrefix(String string) {
        return (String)this.prefixTable.get(string);
    }

    public void forceNSDecl(String string) {
        this.forcedDeclTable.put(string, Boolean.TRUE);
    }

    public void forceNSDecl(String string, String string2) {
        this.setPrefix(string, string2);
        this.forceNSDecl(string);
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        if (!"yes".equals(this.outputProperties.getProperty(OMIT_XML_DECLARATION, "no"))) {
            this.write("<?xml");
            if (this.version == null) {
                this.write(" version=\"1.0\"");
            } else {
                this.write(" version=\"");
                this.write(this.version);
                this.write("\"");
            }
            if (this.outputEncoding != null && this.outputEncoding != "") {
                this.write(" encoding=\"");
                this.write(this.outputEncoding);
                this.write("\"");
            }
            if (this.standalone == null) {
                this.write(" standalone=\"yes\"?>\n");
            } else {
                this.write(" standalone=\"");
                this.write(this.standalone);
                this.write("\"");
            }
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.elementLevel;
        this.nsSupport.pushContext();
        if (this.forceDTD && !this.hasOutputDTD) {
            this.startDTD(string2 == null ? string3 : string2, "", "");
        }
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        if (this.htmlMode && (string3.equals("script") || string3.equals("style"))) {
            this.cdataElement = true;
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!(this.htmlMode && (string.equals("http://www.w3.org/1999/xhtml") || string.equals("")) && (string3.equals("area") || string3.equals("base") || string3.equals("basefont") || string3.equals("br") || string3.equals("col") || string3.equals("frame") || string3.equals("hr") || string3.equals("img") || string3.equals("input") || string3.equals("isindex") || string3.equals("link") || string3.equals("meta") || string3.equals("param")))) {
            this.write("</");
            this.writeName(string, string2, string3, true);
            this.write('>');
        }
        this.cdataElement = false;
        super.endElement(string, string2, string3);
        this.nsSupport.popContext();
        --this.elementLevel;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (!this.cdataElement) {
            this.writeEsc(cArray, n2, n3, false);
        } else {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                this.write(cArray[i2]);
            }
        }
        super.characters(cArray, n2, n3);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        this.writeEsc(cArray, n2, n3, false);
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.write(string);
        this.write(' ');
        this.write(string2);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(string, string2);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(string, string2, string3, attributes);
        super.endElement(string, string2, string3);
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void emptyElement(String string, String string2) throws SAXException {
        this.emptyElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String string) throws SAXException {
        this.emptyElement("", string, "", this.EMPTY_ATTS);
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    private void forceNSDecls() {
        Enumeration enumeration = this.forcedDeclTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrefix(string, null, true);
        }
    }

    private String doPrefix(String string, String string2, boolean bl2) {
        String string3 = this.nsSupport.getURI("");
        if ("".equals(string)) {
            if (bl2 && string3 != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String string4 = bl2 && string3 != null && string.equals(string3) ? "" : this.nsSupport.getPrefix(string);
        if (string4 != null) {
            return string4;
        }
        string4 = (String)this.doneDeclTable.get(string);
        if (string4 != null && ((!bl2 || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && (string4 = (String)this.prefixTable.get(string)) != null && ((!bl2 || string3 != null) && "".equals(string4) || this.nsSupport.getURI(string4) != null)) {
            string4 = null;
        }
        if (string4 == null && string2 != null && !"".equals(string2)) {
            int n2 = string2.indexOf(58);
            if (n2 == -1) {
                if (bl2 && string3 == null) {
                    string4 = "";
                }
            } else {
                string4 = string2.substring(0, n2);
            }
        }
        while (string4 == null || this.nsSupport.getURI(string4) != null) {
            string4 = new StringBuffer().append("__NS").append(++this.prefixCounter).toString();
        }
        this.nsSupport.declarePrefix(string4, string);
        this.doneDeclTable.put(string, string4);
        return string4;
    }

    private void write(char c2) throws SAXException {
        try {
            this.output.write(c2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(String string) throws SAXException {
        try {
            this.output.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void writeAttributes(Attributes attributes) throws SAXException {
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            char[] cArray = attributes.getValue(i2).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(i2), attributes.getLocalName(i2), attributes.getQName(i2), false);
            if (this.htmlMode && this.booleanAttribute(attributes.getLocalName(i2), attributes.getQName(i2), attributes.getValue(i2))) break;
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private boolean booleanAttribute(String string, String string2, String string3) {
        int n2;
        String string4 = string;
        if (string4 == null && (n2 = string2.indexOf(58)) != -1) {
            string4 = string2.substring(n2 + 1, string2.length());
        }
        if (!string4.equals(string3)) {
            return false;
        }
        for (n2 = 0; n2 < this.booleans.length; ++n2) {
            if (!string4.equals(this.booleans[n2])) continue;
            return true;
        }
        return false;
    }

    private void writeEsc(char[] cArray, int n2, int n3, boolean bl2) throws SAXException {
        block6: for (int i2 = n2; i2 < n2 + n3; ++i2) {
            switch (cArray[i2]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (bl2) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    if (!this.unicodeMode && cArray[i2] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(cArray[i2]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(cArray[i2]);
                }
            }
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> enumeration = this.nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = this.nsSupport.getURI(string);
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            this.write(' ');
            if ("".equals(string)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(string);
                this.write("=\"");
            }
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeName(String string, String string2, String string3, boolean bl2) throws SAXException {
        String string4 = this.doPrefix(string, string3, bl2);
        if (string4 != null && !"".equals(string4)) {
            this.write(string4);
            this.write(':');
        }
        if (string2 != null && !"".equals(string2)) {
            this.write(string2);
        } else {
            int n2 = string3.indexOf(58);
            this.write(string3.substring(n2 + 1, string3.length()));
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.write("<!--");
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.write(cArray[i2]);
            if (cArray[i2] != '-' || i2 + 1 > n2 + n3 || cArray[i2 + 1] != '-') continue;
            this.write(' ');
        }
        this.write("-->");
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        char c2;
        if (string == null) {
            return;
        }
        if (this.hasOutputDTD) {
            return;
        }
        this.hasOutputDTD = true;
        this.write("<!DOCTYPE ");
        this.write(string);
        if (string3 == null) {
            string3 = "";
        }
        if (this.overrideSystem != null) {
            string3 = this.overrideSystem;
        }
        char c3 = c2 = string3.indexOf(34) != -1 ? (char)'\'' : '\"';
        if (this.overridePublic != null) {
            string2 = this.overridePublic;
        }
        if (string2 != null && !"".equals(string2)) {
            char c4 = string2.indexOf(34) != -1 ? (char)'\'' : '\"';
            this.write(" PUBLIC ");
            this.write(c4);
            this.write(string2);
            this.write(c4);
            this.write(' ');
        } else {
            this.write(" SYSTEM ");
        }
        this.write(c2);
        this.write(string3);
        this.write(c2);
        this.write(">\n");
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    public String getOutputProperty(String string) {
        return this.outputProperties.getProperty(string);
    }

    public void setOutputProperty(String string, String string2) {
        this.outputProperties.setProperty(string, string2);
        if (string.equals(ENCODING)) {
            this.outputEncoding = string2;
            this.unicodeMode = string2.substring(0, 3).equalsIgnoreCase("utf");
        } else if (string.equals(METHOD)) {
            this.htmlMode = string2.equals("html");
        } else if (string.equals(DOCTYPE_PUBLIC)) {
            this.overridePublic = string2;
            this.forceDTD = true;
        } else if (string.equals(DOCTYPE_SYSTEM)) {
            this.overrideSystem = string2;
            this.forceDTD = true;
        } else if (string.equals(VERSION)) {
            this.version = string2;
        } else if (string.equals(STANDALONE)) {
            this.standalone = string2;
        }
    }
}

