/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.typed;

import java.util.Arrays;

public final class Base64Variant {
    static final char PADDING_CHAR_NONE = '\u0000';
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final int[] _asciiToBase64 = new int[128];
    private final char[] _base64ToAsciiC = new char[64];
    private final byte[] _base64ToAsciiB = new byte[64];
    final String _name;
    final boolean _usesPadding;
    final char _paddingChar;
    final int _maxLineLength;

    public Base64Variant(String string, String string2, boolean bl2, char c2, int n2) {
        this._name = string;
        this._usesPadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        int n3 = string2.length();
        if (n3 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n3 + ")");
        }
        string2.getChars(0, n3, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n4 = 0;
        while (n4 < n3) {
            char c3 = this._base64ToAsciiC[n4];
            this._base64ToAsciiB[n4] = (byte)c3;
            this._asciiToBase64[c3] = n4++;
        }
        if (bl2) {
            this._asciiToBase64[c2] = -2;
        }
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n2) {
        this(base64Variant, string, base64Variant._usesPadding, base64Variant._paddingChar, n2);
    }

    public Base64Variant(Base64Variant base64Variant, String string, boolean bl2, char c2, int n2) {
        this._name = string;
        byte[] byArray = base64Variant._base64ToAsciiB;
        System.arraycopy(byArray, 0, this._base64ToAsciiB, 0, byArray.length);
        char[] cArray = base64Variant._base64ToAsciiC;
        System.arraycopy(cArray, 0, this._base64ToAsciiC, 0, cArray.length);
        int[] nArray = base64Variant._asciiToBase64;
        System.arraycopy(nArray, 0, this._asciiToBase64, 0, nArray.length);
        this._usesPadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
    }

    public String getName() {
        return this._name;
    }

    public boolean usesPadding() {
        return this._usesPadding;
    }

    public boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public int decodeBase64Char(char c2) {
        char c3 = c2;
        return c3 <= '\u007f' ? this._asciiToBase64[c3] : -1;
    }

    public int decodeBase64Byte(byte by2) {
        byte by3 = by2;
        return by3 <= 127 ? this._asciiToBase64[by3] : -1;
    }

    public char encodeBase64BitsAsChar(int n2) {
        return this._base64ToAsciiC[n2];
    }

    public int encodeBase64Chunk(int n2, char[] cArray, int n3) {
        cArray[n3++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 & 0x3F];
        return n3;
    }

    public int encodeBase64Partial(int n2, int n3, char[] cArray, int n4) {
        cArray[n4++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n4++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        if (this._usesPadding) {
            cArray[n4++] = n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : this._paddingChar;
            cArray[n4++] = this._paddingChar;
        } else if (n3 == 2) {
            cArray[n4++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public byte encodeBase64BitsAsByte(int n2) {
        return this._base64ToAsciiB[n2];
    }

    public int encodeBase64Chunk(int n2, byte[] byArray, int n3) {
        byArray[n3++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 & 0x3F];
        return n3;
    }

    public int encodeBase64Partial(int n2, int n3, byte[] byArray, int n4) {
        byArray[n4++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n4++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        if (this._usesPadding) {
            byte by2 = (byte)this._paddingChar;
            byArray[n4++] = n3 == 2 ? this._base64ToAsciiB[n2 >> 6 & 0x3F] : by2;
            byArray[n4++] = by2;
        } else if (n3 == 2) {
            byArray[n4++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public String toString() {
        return this._name;
    }
}

