/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.data.NonDegeneratedColumn;
import com.ibm.bi.predict.data.ParamsInfo;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.UserMessageException;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Optional;

public class AnalyzeTarget {
    private final boolean isZeroInflated;
    private static final double SECOND_BIN = 2.0;
    private static final Logger LOG = PredictLoggerFactory.getLogger(AnalyzeTarget.class);

    public AnalyzeTarget(boolean isZeroInflated) {
        this.isZeroInflated = isZeroInflated;
    }

    public AnalyzeTarget(DataAccessProvider provider, ParamsInfo params, DataContext context) {
        this(provider, context.addParamsInfo(params), params.getTargetIndex());
    }

    public AnalyzeTarget(DataAccessProvider provider, DataContext context, Optional<Integer> targetIndex) {
        boolean treatZeroAsMissing = context.getBoolean("treatZeroInflatedAsMissing", false);
        int binCount = context.getInt("binCount", 5);
        this.isZeroInflated = AnalyzeTarget.isZeroInflated(treatZeroAsMissing, provider, targetIndex, binCount);
        if (this.isZeroInflated) {
            LOG.debug("The target is zero-inflated");
        }
        if (!AnalyzeTarget.isNonDegenerated(provider, context, targetIndex)) {
            LOG.warn("The target is a degenerate field and excluded from further analysis");
            throw new UserMessageException(MessageCode.DEGENERATE_TARGET);
        }
    }

    private static boolean isNonDegenerated(DataAccessProvider provider, DataContext context, Optional<Integer> targetIndex) {
        NonDegeneratedColumn nonDegeneratedColumn = new NonDegeneratedColumn(context.getDouble("maxRatioOfUniquesToTotalRows", 0.5), context.getInt("minCategoriesToBeUseful", 2));
        if (targetIndex.isPresent()) {
            return nonDegeneratedColumn.isNonDegenerated(targetIndex.get(), provider.getMetaData());
        }
        return true;
    }

    public boolean filter(Double value, FieldType type) {
        if (NumericUtils.isMissingValue((double)value)) {
            return false;
        }
        if (this.isZeroInflated) {
            return !NumericUtils.equals((double)value, (double)0.0);
        }
        return true;
    }

    public void setTargetZeroInflationStatus(DataColumn target) {
        if (target != null && this.isZeroInflated) {
            target.addStatus(DataColumn.Status.ZERO_INFLATED);
        }
    }

    public boolean isZeroInflatedTarget() {
        return this.isZeroInflated;
    }

    private static boolean isZeroInflated(boolean treatZeroAsMissing, DataAccessProvider provider, Optional<Integer> targetIndex, int binCount) {
        FieldType type = FieldType.NUMERICAL;
        if (targetIndex.isPresent()) {
            type = provider.getMetaData().getFieldType(targetIndex.get());
        }
        if (!treatZeroAsMissing || type.equals((Object)FieldType.CATEGORICAL)) {
            return false;
        }
        int[] counts = AnalyzeTarget.countZeroAndMissingValuesInData(provider, targetIndex);
        int zeroCount = counts[0];
        int missingCount = counts[1];
        MetaData metaData = provider.getMetaData();
        int validValueCount = metaData.rowCount() - missingCount;
        return (double)zeroCount > 2.0 * (double)validValueCount / (double)binCount;
    }

    private static int[] countZeroAndMissingValuesInData(DataAccessProvider provider, Optional<Integer> targetIndex) {
        if (!targetIndex.isPresent()) {
            return new int[]{0, 0};
        }
        int zeroCount = 0;
        int missingCount = 0;
        DataIterator it = provider.getDataIterator();
        while (it.hasNext()) {
            DataRow row = (DataRow)it.next();
            double targetValue = row.getValue(targetIndex.get());
            if (Double.isNaN(targetValue)) {
                ++missingCount;
                continue;
            }
            if (!NumericUtils.equals((double)targetValue, (double)0.0)) continue;
            ++zeroCount;
        }
        it.reset();
        return new int[]{zeroCount, missingCount};
    }
}

