/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.google.common.primitives.Doubles;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.store.DataArray;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.ScratchMemoryAllocation;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class ColumnDataBuilder {
    private final DataAccessProvider provider;
    private final Optional<List<double[]>> rows;
    private final List<Set<Double>> uniqueCategories;
    private int[] metaDataColumns;
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ColumnDataBuilder.class);
    private int allocationTimeout;

    public ColumnDataBuilder(DataAccessProvider provider, int[] metaDataColumns, Optional<Integer> targetIndex, BiPredicate<Double, FieldType> targetValueFilter, int allocationTimeout) {
        this.provider = provider;
        this.metaDataColumns = metaDataColumns;
        this.allocationTimeout = allocationTimeout;
        this.uniqueCategories = ColumnDataBuilder.initUniqueCategories(metaDataColumns.length);
        this.rows = this.makeRows(targetIndex, targetValueFilter);
    }

    public Optional<double[]> buildData(int columnIndex) {
        Optional colData;
        if (!this.rows.isPresent()) {
            return Optional.empty();
        }
        List<double[]> rows = this.rows.get();
        MetaData metaData = this.provider.getMetaData();
        HashMap map = new HashMap();
        if (metaData.getFieldType(this.metaDataColumns[columnIndex]) == FieldType.CATEGORICAL && this.uniqueCategories.get(columnIndex).size() != metaData.getFieldCategories(this.metaDataColumns[columnIndex])) {
            this.uniqueCategories.get(columnIndex).stream().sorted().forEachOrdered(v -> map.put(v, Double.valueOf(map.size())));
        }
        if ((colData = ScratchMemoryAllocation.allocate(() -> new double[rows.size()], (int)this.allocationTimeout)).isPresent()) {
            double[] dataArr = (double[])colData.get();
            for (int i = 0; i < rows.size(); ++i) {
                double data = rows.get(i)[columnIndex];
                dataArr[i] = NumericUtils.isMissingValue((double)data) || map.isEmpty() ? data : (Double)map.get(data);
            }
            return colData;
        }
        return Optional.empty();
    }

    public List<Category> buildCategories(int columnIndex) {
        MetaData metaData = this.provider.getMetaData();
        if (metaData.getFieldType(this.metaDataColumns[columnIndex]) == FieldType.NUMERICAL) {
            return null;
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        this.uniqueCategories.get(columnIndex).stream().sorted().forEachOrdered(category -> {
            int identifier = category.intValue();
            String label = null;
            List<Object> aggregationTypes = Collections.emptyList();
            try {
                label = metaData.getFieldCategoryLabel(this.metaDataColumns[columnIndex], identifier);
            }
            catch (UnsupportedOperationException e) {
                label = category.toString();
                LOGGER.warn("Unsupported operation, getFieldCategoryLabel() not implemented", (Throwable)e);
            }
            try {
                aggregationTypes = metaData.getFieldCategoryAggregations(this.metaDataColumns[columnIndex], identifier);
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warn("getFieldCategoryAggregations() is not implemented, continuing with empty list", (Throwable)e);
            }
            categories.add(Category.forString(label, identifier).setAggregationType(aggregationTypes.isEmpty() ? AggregationType.NONE : (AggregationType)aggregationTypes.get(0)));
        });
        return categories;
    }

    public Tuple<List<Set<Category>>, List<DataArray>> buildNestedCategories(int columnIndex) {
        MetaData metaData = this.provider.getMetaData();
        ArrayList nestedCategories = new ArrayList();
        ArrayList<List<Integer>> dataValues = new ArrayList<List<Integer>>();
        this.uniqueCategories.get(columnIndex).stream().sorted().forEachOrdered(category -> {
            List<String> label = metaData.getFieldCategoryLabels(this.metaDataColumns[columnIndex], category.intValue());
            for (int i = 0; i < label.size(); ++i) {
                if (nestedCategories.size() <= i) {
                    nestedCategories.add(new LinkedHashSet());
                    dataValues.add(new ArrayList());
                }
                if (((Set)nestedCategories.get(i)).contains(Category.forString(label.get(i)))) {
                    int pos = new ArrayList((Collection)nestedCategories.get(i)).indexOf(Category.forString(label.get(i)));
                    ((List)dataValues.get(i)).add(pos);
                } else {
                    ((List)dataValues.get(i)).add(((Set)nestedCategories.get(i)).size());
                }
                ((Set)nestedCategories.get(i)).add(Category.forString(label.get(i)));
            }
        });
        return Tuple.of(nestedCategories, this.getDataArrays(dataValues));
    }

    private List<DataArray> getDataArrays(List<List<Integer>> dataValues) {
        return dataValues.stream().map(v -> DataArray.of(Doubles.toArray((Collection)v))).collect(Collectors.toList());
    }

    private Optional<List<double[]>> makeRows(Optional<Integer> targetIndex, BiPredicate<Double, FieldType> targetValueFilter) {
        FieldType targetType = targetIndex.isPresent() ? this.provider.getMetaData().getFieldType(targetIndex.get()) : null;
        ArrayList<double[]> newRows = new ArrayList<double[]>();
        DataIterator it = this.provider.getDataIterator();
        while (it.hasNext()) {
            DataRow row = (DataRow)it.next();
            Optional<RowHolder> newRow = this.makeRow(row, this.metaDataColumns, targetValueFilter, targetIndex, targetType);
            if (!newRow.isPresent()) continue;
            if (newRow.get().currRow.isPresent()) {
                newRows.add(newRow.get().currRow.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(newRows);
    }

    private Optional<RowHolder> makeRow(DataRow row, int[] metaDataColumns, BiPredicate<Double, FieldType> targetValueFilter, Optional<Integer> targetIndex, FieldType targetType) {
        RowHolder holder = new RowHolder();
        if (targetIndex.isPresent() && !targetValueFilter.test(row.getValue(targetIndex.get()), targetType)) {
            return Optional.empty();
        }
        holder.currRow = ScratchMemoryAllocation.allocate(() -> new double[metaDataColumns.length], (int)this.allocationTimeout);
        if (holder.currRow.isPresent()) {
            double[] rowArr = holder.currRow.get();
            for (int i = 0; i < metaDataColumns.length; ++i) {
                rowArr[i] = row.getValue(metaDataColumns[i]);
                if (!this.collectCategory(i, rowArr[i])) continue;
                try {
                    this.uniqueCategories.get(i).add(rowArr[i]);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    LOGGER.warn("Handling OOM by returning Optional.empty()", (Throwable)e);
                    return Optional.empty();
                }
            }
            return Optional.of(holder);
        }
        holder.currRow = Optional.empty();
        return Optional.of(holder);
    }

    private boolean collectCategory(int columnIndex, double columnData) {
        MetaData metadata = this.provider.getMetaData();
        return !NumericUtils.isMissingValue((double)columnData) && metadata.getFieldType(this.metaDataColumns[columnIndex]) != FieldType.NUMERICAL;
    }

    private static List<Set<Double>> initUniqueCategories(int columnCount) {
        ArrayList<Set<Double>> categories = new ArrayList<Set<Double>>();
        for (int i = 0; i < columnCount; ++i) {
            categories.add(new HashSet());
        }
        return categories;
    }

    private static class RowHolder {
        Optional<double[]> currRow;

        private RowHolder() {
        }
    }
}

