/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Config;
import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.data.ParamsInfo;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.Map;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataContext
extends Context {
    public static final String MIN_CATEGORIES_TO_BE_USEFUL = "minCategoriesToBeUseful";
    public static final String MAX_RATIO_OF_UNIQUES_TO_TOTAL_ROWS = "maxRatioOfUniquesToTotalRows";
    public static final String BIN_COUNT = "binCount";
    public static final String MISSING_VALUES_IN_SEPARATE_CATEGORY = "missingValuesInSeparateCategory";
    public static final String MAX_CATEGORIES_TO_PROCESS = "maxCategoriesToProcess";
    public static final String MIN_UNMERGED_CATEGORY_FREQUENCY = "minUnmergedCategoryFrequency";
    public static final String MIN_RATIO_OF_CATEGORIES_NOT_IN_OTHER = "minRatioOfCategoriesNotInOther";
    public static final String TREAT_ZERO_INFLATED_AS_MISSING = "treatZeroInflatedAsMissing";
    public static final String HANDLE_OUTLIERS_IN_TARGET = "handleOutliersInTarget";
    public static final String OUTLIER_MULTIPLIER_CONSTANT = "outlierMultiplierConstant";
    public static final String OUTLIER_PERCENTILE = "outlierPercentile";
    public static final String ALLOCATION_TIMEOUT = "allocationTimeout";
    public static final String LOCALE = "locale";
    public static final String RELEASE_PROVIDER = "releaseProvider";
    public static final String SAMPLED_DATA = "sampledData";
    public static final String TARGET = "target";
    public static final String INPUTS = "inputs";
    public static final String VERSION = "version";
    public static final String REQUEST_ID = "requestId";

    public DataContext addParamsInfo(ParamsInfo params) {
        this.setValue(SAMPLED_DATA, params.getSampledData());
        return this;
    }

    public DataContext mixinParameters(JSONObject params) {
        this.setIfPresent(TARGET, (Map)params);
        this.setIfPresent(INPUTS, (Map)params);
        this.setRequired(VERSION, params);
        this.setIfPresent(SAMPLED_DATA, (Map)params);
        this.setIfPresent(LOCALE, (Map)params);
        return this;
    }

    public DataContext parseJson(JSONObject obj) {
        int minCategoriesToBeUseful = JsonUtils.getOptionalInt((JSONObject)obj, (String)MIN_CATEGORIES_TO_BE_USEFUL, (int)2);
        this.setValue(MIN_CATEGORIES_TO_BE_USEFUL, minCategoriesToBeUseful);
        double maxRatioOfUniquesToTotalRows = JsonUtils.getOptionalDouble((JSONObject)obj, (String)MAX_RATIO_OF_UNIQUES_TO_TOTAL_ROWS, (double)0.5);
        this.setValue(MAX_RATIO_OF_UNIQUES_TO_TOTAL_ROWS, maxRatioOfUniquesToTotalRows);
        int binCount = JsonUtils.getOptionalInt((JSONObject)obj, (String)BIN_COUNT, (int)5);
        this.setValue(BIN_COUNT, binCount);
        boolean missingValuesInSeparateCategory = JsonUtils.getOptionalBoolean((JSONObject)obj, (String)MISSING_VALUES_IN_SEPARATE_CATEGORY, (boolean)true);
        this.setValue(MISSING_VALUES_IN_SEPARATE_CATEGORY, missingValuesInSeparateCategory);
        int maxCategoriesToProcess = JsonUtils.getOptionalInt((JSONObject)obj, (String)MAX_CATEGORIES_TO_PROCESS, (int)50);
        this.setValue(MAX_CATEGORIES_TO_PROCESS, maxCategoriesToProcess);
        int minUnmergedCategoryFrequency = JsonUtils.getOptionalInt((JSONObject)obj, (String)MIN_UNMERGED_CATEGORY_FREQUENCY, (int)3);
        this.setValue(MIN_UNMERGED_CATEGORY_FREQUENCY, minUnmergedCategoryFrequency);
        double minRatioOfCategoriesNotInOther = JsonUtils.getOptionalDouble((JSONObject)obj, (String)MIN_RATIO_OF_CATEGORIES_NOT_IN_OTHER, (double)0.75);
        this.setValue(MIN_RATIO_OF_CATEGORIES_NOT_IN_OTHER, minRatioOfCategoriesNotInOther);
        boolean treatZeroInflatedAsMissing = JsonUtils.getOptionalBoolean((JSONObject)obj, (String)TREAT_ZERO_INFLATED_AS_MISSING, (boolean)false);
        this.setValue(TREAT_ZERO_INFLATED_AS_MISSING, treatZeroInflatedAsMissing);
        boolean handleOutliersInTarget = JsonUtils.getOptionalBoolean((JSONObject)obj, (String)HANDLE_OUTLIERS_IN_TARGET, (boolean)true);
        this.setValue(HANDLE_OUTLIERS_IN_TARGET, handleOutliersInTarget);
        double outlierMultiplierConstant = JsonUtils.getOptionalDouble((JSONObject)obj, (String)OUTLIER_MULTIPLIER_CONSTANT, (double)1.5);
        this.setValue(OUTLIER_MULTIPLIER_CONSTANT, outlierMultiplierConstant);
        double outlierPercentile = JsonUtils.getOptionalDouble((JSONObject)obj, (String)OUTLIER_PERCENTILE, (double)0.05);
        this.setValue(OUTLIER_PERCENTILE, outlierPercentile);
        int allocationTimeout = JsonUtils.getOptionalInt((JSONObject)obj, (String)ALLOCATION_TIMEOUT, (int)10000);
        this.setValue(ALLOCATION_TIMEOUT, allocationTimeout);
        String locale = JsonUtils.getOptionalString((JSONObject)obj, (String)LOCALE, (String)"en");
        this.setValue(LOCALE, locale);
        return this;
    }

    public static DataContext configToContext(Config config) {
        DataContext context = new DataContext();
        context.setValue(MIN_CATEGORIES_TO_BE_USEFUL, config.minCategoriesToBeUseful());
        context.setValue(MAX_RATIO_OF_UNIQUES_TO_TOTAL_ROWS, config.maxRatioOfUniquesToTotalRows());
        context.setValue(BIN_COUNT, config.binCount());
        context.setValue(MISSING_VALUES_IN_SEPARATE_CATEGORY, config.missingValuesInSeparateCategory());
        context.setValue(MAX_CATEGORIES_TO_PROCESS, config.maxCategoriesToProcess());
        context.setValue(MIN_UNMERGED_CATEGORY_FREQUENCY, config.minUnmergedCategoryFrequency());
        context.setValue(MIN_RATIO_OF_CATEGORIES_NOT_IN_OTHER, config.minFrequencyPercent());
        context.setValue(TREAT_ZERO_INFLATED_AS_MISSING, config.treatZeroInflatedAsMissing());
        context.setValue(HANDLE_OUTLIERS_IN_TARGET, config.handleOutliersInTarget());
        context.setValue(OUTLIER_MULTIPLIER_CONSTANT, config.outlierMultiplierConstant());
        context.setValue(OUTLIER_PERCENTILE, config.outlierPercentile());
        context.setValue(ALLOCATION_TIMEOUT, config.allocationTimeout());
        context.setValue(LOCALE, config.locale().toString());
        return context;
    }

    protected void setRequired(String key, JSONObject params) {
        this.setValue(key, JsonUtils.getRequiredString((JSONObject)params, (String)key));
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }
}

