/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.data.store.DataArray;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public class DataFrame
implements Iterable<double[]> {
    private final DataArray[] columns;
    private final List<Integer> fieldCategories;
    private final List<DataColumn.ColumnMeta> fieldMeta;
    private final boolean hasTarget;
    private SoftReference<double[][]> records;

    public DataFrame(List<DataColumn.ColumnMeta> fieldMeta, List<Integer> fieldCategories, DataArray[] columns, boolean hasTarget) {
        this.columns = columns;
        this.fieldCategories = fieldCategories;
        this.fieldMeta = fieldMeta;
        this.hasTarget = hasTarget;
        this.records = new SoftReference<Object>(null);
    }

    public int getNumFields() {
        return this.fieldMeta.size();
    }

    public int getNumRows() {
        return this.columns.length > 0 ? this.columns[0].size() : 0;
    }

    public int[] getDriversIndexes() {
        return this.hasTarget ? IntStream.range(1, this.fieldMeta.size()).toArray() : IntStream.range(0, this.fieldMeta.size()).toArray();
    }

    public int getFieldCategories(int i) {
        return this.fieldCategories.get(i);
    }

    public String getFieldName(int i) {
        return this.fieldMeta.get(i).getId();
    }

    public FieldType getFieldType(int i) {
        return this.fieldMeta.get(i).getType();
    }

    public AggregationType getAggregationType(int i) {
        return this.fieldMeta.get(i).getAggregationType();
    }

    public double getValue(int fieldIndex, int rowIndex) {
        return this.columns[fieldIndex].value(rowIndex);
    }

    public String getFieldLabel(int i) {
        return this.fieldMeta.get(i).getLabel();
    }

    public String getTargetFieldName() {
        return this.hasTarget ? this.getFieldName(this.getTargetIndex()) : null;
    }

    public int getTargetIndex() {
        return this.hasTarget ? 0 : -1;
    }

    public FieldType getTargetType() {
        return this.getFieldType(this.getTargetIndex());
    }

    @Override
    public Iterator<double[]> iterator() {
        double[][] rows = this.records.get();
        if (rows == null) {
            rows = new double[this.getNumRows()][this.getNumFields()];
            for (int i = 0; i < rows.length; ++i) {
                for (int j = 0; j < rows[i].length; ++j) {
                    rows[i][j] = this.columns[j].value(i);
                }
            }
            this.records = new SoftReference<double[][]>(rows);
        }
        return Arrays.asList(rows).iterator();
    }
}

