/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

import com.ibm.bi.predict.data.Config;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;

public class NonDegeneratedColumn {
    private static final Logger LOG = PredictLoggerFactory.getLogger(NonDegeneratedColumn.class);
    private final double maxCategoriesPercentage;
    private final int minCategories;

    public NonDegeneratedColumn(Config config) {
        this(config.maxRatioOfUniquesToTotalRows(), config.minCategoriesToBeUseful());
    }

    public NonDegeneratedColumn(double maxCategoriesPercentage, int minCategories) {
        this.maxCategoriesPercentage = maxCategoriesPercentage;
        this.minCategories = minCategories;
    }

    public boolean isNonDegenerated(Integer columnIdx, MetaData metaData) {
        if (metaData.getFieldType(columnIdx) != FieldType.CATEGORICAL) {
            return true;
        }
        double dataSetMaxCategories = this.maxCategoriesPercentage * (double)metaData.rowCount();
        int fieldCategories = metaData.getFieldCategories(columnIdx);
        if (fieldCategories < this.minCategories || (double)fieldCategories > dataSetMaxCategories) {
            LOG.debug(String.format("Degenerate Field: %s", metaData.getFieldIdentifier(columnIdx)));
            return false;
        }
        return true;
    }
}

