/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.matrix;

import com.ibm.bi.predict.data.matrix.DataVector;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class DataVectorAsMap
extends DataVector {
    private final TreeMap<Integer, Double> data = new TreeMap();

    DataVectorAsMap(double[] data) {
        this(data.length);
        for (int i = 0; i < data.length; ++i) {
            double v = data[i];
            if (NumericUtils.isZero((double)v)) continue;
            this.data.put(i, v);
        }
    }

    DataVectorAsMap(int length) {
        super(length);
    }

    @Override
    public DataVector copy() {
        DataVectorAsMap copy = new DataVectorAsMap(this.length);
        copy.data.putAll(this.data);
        return copy;
    }

    @Override
    public double getValue(int index) {
        return this.data.getOrDefault(index, 0.0);
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public void walkAll(BiConsumer<Integer, Double> consumer) {
        for (int i = 0; i < this.length; ++i) {
            consumer.accept(i, this.getValue(i));
        }
    }

    @Override
    public void walkNonZero(BiConsumer<Integer, Double> consumer) {
        for (Map.Entry<Integer, Double> e : this.data.entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }

    public String toString() {
        return "[" + this.length + " -- " + this.data.entrySet().stream().map(e -> e.getKey() + ":" + NumberFormatter.format((Locale)Locale.US, (boolean)false, (double)((Double)e.getValue()))).collect(Collectors.joining(" ")) + "]";
    }

    @Override
    protected void increment(int index, double value) {
        if (index < 0 || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (NumericUtils.isZero((double)value)) {
            return;
        }
        this.setValue(index, this.getValue(index) + value);
    }

    @Override
    public void unsafeSetValue(int index, double value) {
        if (index < 0 || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (NumericUtils.isZero((double)value)) {
            this.data.remove(index);
        } else {
            this.data.put(index, value);
        }
    }

    @Override
    public double[] getDataVector() {
        double[] d = new double[this.length];
        for (Map.Entry<Integer, Double> e : this.data.entrySet()) {
            d[e.getKey().intValue()] = e.getValue();
        }
        return d;
    }
}

