/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data.store;

import com.ibm.bi.predict.data.store.DataArray;
import java.util.Arrays;

class ByteArray
extends DataArray {
    private static final byte MISSING = -128;
    private final byte[] values;

    static ByteArray fromDoubles(double[] data) {
        byte[] coded = new byte[data.length];
        for (int i = 0; i < coded.length; ++i) {
            coded[i] = Double.isNaN(data[i]) ? -128 : (byte)data[i];
        }
        return new ByteArray(coded);
    }

    private ByteArray(byte[] values) {
        super(values.length);
        this.values = values;
    }

    @Override
    public final double value(int i) {
        byte value = this.values[i];
        return value == -128 ? Double.NaN : (double)value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.values, ((ByteArray)o).values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }
}

