/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.csv;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.csv.CSVBadDataException;
import com.ibm.bi.predict.dataaccess.csv.CSVDataIterator;
import com.ibm.bi.predict.dataaccess.csv.CSVDataRow;
import com.ibm.bi.predict.dataaccess.csv.CSVField;
import com.ibm.bi.predict.dataaccess.csv.CSVMetaData;
import com.ibm.bi.predict.dataaccess.csv.CSVUtils;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataAccessProvider
implements DataAccessProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVDataAccessProvider.class);
    private CSVMetaData metadata;
    private List<CSVDataRow> data = new ArrayList<CSVDataRow>();

    public CSVDataAccessProvider(String dataPath) throws IOException, CSVBadDataException {
        this(dataPath, false);
    }

    public CSVDataAccessProvider(String dataPath, boolean isZipFile) throws IOException, CSVBadDataException {
        this.load(dataPath, isZipFile);
    }

    private void load(String dataPath, boolean isZipFile) throws IOException, CSVBadDataException {
        ZipFile zipFile = null;
        BufferedReader bufferReader = null;
        try {
            if (isZipFile) {
                zipFile = new ZipFile(dataPath);
            }
            bufferReader = this.getDataReader(dataPath, zipFile, isZipFile);
            this.generateDataAndMetadata(bufferReader);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while loading data file", (Throwable)e);
            throw new IOException("An error occurred while loading data file", e);
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
            if (bufferReader != null) {
                bufferReader.close();
            }
        }
    }

    private List<CSVField> makeCSVFields(List<String> ids, List<FieldType> types, List<Map<String, Integer>> catMaps) {
        ArrayList<CSVField> fields = new ArrayList<CSVField>();
        for (int i = 0; i < ids.size(); ++i) {
            CSVField field = new CSVField(i, ids.get(i), types.get(i), this.invert(catMaps.get(i)));
            fields.add(field);
        }
        return fields;
    }

    private String[] invert(Map<String, Integer> map) {
        if (map.isEmpty()) {
            return null;
        }
        String[] result = new String[map.size()];
        map.forEach((s, i) -> {
            result[i.intValue()] = s;
        });
        return result;
    }

    private double[] processDataRow(String line, List<FieldType> types, List<Map<String, Integer>> catMaps, int rowNumber) {
        List<String> valueStrings = CSVUtils.splitIntoFields(line, rowNumber);
        if (valueStrings.size() != types.size()) {
            throw new CSVBadDataException("Expected " + types.size() + " columns for each row, but found " + valueStrings.size() + " at line #" + rowNumber);
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int columnIndex = 0; columnIndex < valueStrings.size(); ++columnIndex) {
            String valueString = valueStrings.get(columnIndex);
            if (CSVUtils.isMissing(valueString)) {
                values.add(Double.NaN);
                continue;
            }
            FieldType fieldType = this.getFieldType(columnIndex, types, valueString);
            if (fieldType == FieldType.CATEGORICAL) {
                Integer categoryIndex = this.getCategoryIndex(columnIndex, valueString, catMaps);
                values.add(categoryIndex.doubleValue());
                continue;
            }
            values.add(CSVUtils.getDouble(valueString));
        }
        double[] dataRow = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            dataRow[i] = (Double)values.get(i);
        }
        return dataRow;
    }

    private Integer getCategoryIndex(int columnIndex, String category, List<Map<String, Integer>> catMaps) {
        return catMaps.get(columnIndex).computeIfAbsent(category, k -> ((Map)catMaps.get(columnIndex)).size());
    }

    private FieldType getFieldType(int columnIndex, List<FieldType> types, String valueString) {
        FieldType fileType = types.get(columnIndex);
        if (fileType == null) {
            fileType = CSVUtils.isNumeric(valueString) ? FieldType.NUMERICAL : FieldType.CATEGORICAL;
            types.set(columnIndex, fileType);
        }
        return fileType;
    }

    private List<String> processHeader(String firstLine) throws CSVBadDataException {
        ArrayList<String> ids = new ArrayList<String>();
        if (firstLine == null) {
            LOGGER.error("No lines in file");
            throw new CSVBadDataException("No lines in file");
        }
        List<String> rowValues = CSVUtils.splitIntoFields(firstLine, 1);
        for (String rowValue : rowValues) {
            if (rowValue == null) {
                LOGGER.error("Missing column header in file");
                throw new CSVBadDataException("Missing column header in file");
            }
            ids.add(rowValue);
        }
        return ids;
    }

    @Override
    public CSVMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public CSVDataIterator getDataIterator() {
        return new CSVDataIterator(this.data);
    }

    @Override
    public Decorator getDecorator() {
        throw new UnsupportedOperationException();
    }

    private BufferedReader getDataReader(String dataPath, ZipFile zipFile, boolean isZipFile) throws IOException {
        if (isZipFile) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ZipEntry entry = entries.nextElement();
            InputStream inStream = zipFile.getInputStream(entry);
            return new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(dataPath), "UTF-8");
        return new BufferedReader(fileReader);
    }

    private void generateDataAndMetadata(BufferedReader bufferReader) throws IOException {
        String line = bufferReader.readLine();
        List<String> ids = this.processHeader(line);
        ArrayList<FieldType> types = new ArrayList<FieldType>();
        ArrayList<Map<String, Integer>> categoricalFieldValues = new ArrayList<Map<String, Integer>>();
        for (int columnIndex = 0; columnIndex < ids.size(); ++columnIndex) {
            types.add(null);
            categoricalFieldValues.add(new HashMap());
        }
        int row = 1;
        while ((line = bufferReader.readLine()) != null && !line.trim().isEmpty()) {
            this.data.add(new CSVDataRow(this.processDataRow(line, types, categoricalFieldValues, ++row)));
        }
        List<CSVField> fields = this.makeCSVFields(ids, types, categoricalFieldValues);
        this.metadata = new CSVMetaData(this.data.size(), fields);
    }

    @Override
    public void close() {
        this.data = null;
        this.metadata = null;
    }

    public boolean isReleased() {
        return this.data == null && this.metadata == null;
    }
}

