/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.csv;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.csv.CSVField;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import java.util.Collections;
import java.util.List;

public class CSVMetaData
implements MetaData {
    private int rowCount;
    private List<CSVField> fields;

    public CSVMetaData(int rowCount, List<CSVField> fields) {
        this.rowCount = rowCount;
        this.fields = fields;
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int fieldCount() {
        return this.fields.size();
    }

    @Override
    public String getFieldIdentifier(int columnIndex) throws IllegalDataAccessRequest {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getId();
    }

    @Override
    public FieldType getFieldType(int columnIndex) throws IllegalDataAccessRequest {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getType();
    }

    @Override
    public int getFieldCategories(int columnIndex) throws IllegalDataAccessRequest {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getCategories();
    }

    @Override
    public StatisticStatus getStatisticStatus(String statisticName, int columnIndex) throws IllegalDataAccessRequest {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        if (columnIndex < 0 || columnIndex > this.fields.size()) {
            throw new IllegalDataAccessRequest("Illegal column index requested: " + columnIndex);
        }
        CSVField field = this.fields.get(columnIndex);
        if (field.getType() != FieldType.CATEGORICAL) {
            throw new IllegalDataAccessRequest("Requested category label when field was not categorical: " + field.getId());
        }
        if (categoryIndex < 0 || categoryIndex >= field.getCategories()) {
            throw new IllegalDataAccessRequest("Illegal category index requested: " + categoryIndex);
        }
        return field.getCategoryValue(categoryIndex);
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIndex, int categoryIndex) {
        return Collections.emptyList();
    }

    @Override
    public AggregationType getFieldAggregation(int columnIndex) {
        return AggregationType.NONE;
    }

    @Override
    public String getFieldDisplayLabel(int columnIndex) {
        if (columnIndex < 0 || columnIndex > this.fields.size()) {
            throw new IllegalDataAccessRequest("Illegal column index requested");
        }
        return String.format("%s_label", this.fields.get(columnIndex).getId());
    }

    public int getFieldIndex(String fieldName) {
        int fieldIdx = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getId().equals(fieldName)) continue;
            fieldIdx = i;
        }
        return fieldIdx;
    }
}

