/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.csv;

import com.ibm.bi.predict.dataaccess.csv.CSVBadDataException;
import java.util.ArrayList;
import java.util.List;

public class CSVUtils {
    private static final int FIELD_MAX_SIZE = 65536;

    private CSVUtils() {
    }

    @Deprecated
    public static String[] parseLine(String line) {
        List<String> fields = CSVUtils.splitIntoFields(line, 0);
        return fields.toArray(new String[fields.size()]);
    }

    public static List<String> splitIntoFields(String line, int lineNumber) {
        ArrayList<String> items = new ArrayList<String>();
        boolean inQuote = false;
        int N = line.length();
        char[] currentWord = new char[65536];
        int currentWordLength = 0;
        int indexOfLastQuotedItemInWord = 0;
        for (int i = 0; i < N; ++i) {
            char c = line.charAt(i);
            if (c == ',' && !inQuote) {
                items.add(CSVUtils.buildWordFromArray(currentWord, currentWordLength, indexOfLastQuotedItemInWord));
                currentWordLength = 0;
                continue;
            }
            if (c == '\"') {
                if (!inQuote) {
                    inQuote = true;
                    continue;
                }
                if (i < N - 1 && line.charAt(i + 1) == '\"') {
                    CSVUtils.checkLength(lineNumber, currentWordLength);
                    currentWord[currentWordLength++] = 34;
                    ++i;
                    continue;
                }
                inQuote = false;
                indexOfLastQuotedItemInWord = currentWordLength;
                continue;
            }
            CSVUtils.checkLength(lineNumber, currentWordLength);
            if (!inQuote && currentWordLength <= 0 && Character.isWhitespace(c)) continue;
            currentWord[currentWordLength++] = c;
        }
        if (inQuote) {
            String where = lineNumber > 0 ? " at line #" + lineNumber : "";
            throw new CSVBadDataException("Unbalanced quotes" + where);
        }
        items.add(CSVUtils.buildWordFromArray(currentWord, currentWordLength, indexOfLastQuotedItemInWord));
        return items;
    }

    private static void checkLength(int lineNumber, int currentWordLength) {
        if (currentWordLength >= 65536) {
            String where = lineNumber > 0 ? " at line #" + lineNumber : "";
            throw new CSVBadDataException("Cannot handle field with longer than 65536 characters" + where);
        }
    }

    private static String buildWordFromArray(char[] currentWord, int currentWordLength, int indexOfLastQuotedItemInWord) {
        while (currentWordLength > 0 && currentWordLength > indexOfLastQuotedItemInWord && Character.isWhitespace(currentWord[currentWordLength - 1])) {
            --currentWordLength;
        }
        return new String(currentWord, 0, currentWordLength);
    }

    static boolean isMissing(String string) {
        return string == null || string.isEmpty();
    }

    static boolean isNumeric(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    static Double getDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }
}

