/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.endorv2;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.endorv2.V2Column;
import com.ibm.bi.predict.dataaccess.endorv2.V2DataAccessProvider;
import com.ibm.bi.predict.dataaccess.endorv2.V2DataIterator;
import com.ibm.bi.predict.dataaccess.endorv2.V2DataParser;
import com.ibm.bi.predict.dataaccess.endorv2.V2DataRow;
import com.ibm.bi.predict.dataaccess.endorv2.V2Edge;
import com.ibm.bi.predict.dataaccess.endorv2.V2Field;
import com.ibm.bi.predict.dataaccess.endorv2.V2Identifier;
import com.ibm.bi.predict.dataaccess.endorv2.V2Item;
import com.ibm.bi.predict.dataaccess.endorv2.V2ItemClass;
import com.ibm.bi.predict.dataaccess.endorv2.V2MetaData;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class EndorResultSetV2Parser {
    private final JSONObject dataJson;
    private final JSONObject params;

    public static boolean isV2Data(JSONObject inputJson) {
        if (inputJson == null) {
            return false;
        }
        if (inputJson.containsKey((Object)"data") && inputJson.containsKey((Object)"params")) {
            inputJson = JsonHelpers.getObject(inputJson, "data");
        }
        return inputJson.containsKey((Object)"data") && inputJson.containsKey((Object)"edges") && JsonHelpers.optString(inputJson, "version").filter("2"::equals).isPresent();
    }

    public EndorResultSetV2Parser(JSONObject json) {
        this.params = JsonHelpers.getObject(json, "params");
        this.dataJson = JsonHelpers.getObject(json, "data");
    }

    public EndorResultSetV2Parser(JSONObject dataJson, JSONObject params) {
        this.dataJson = dataJson;
        this.params = params;
    }

    public DataAccessProvider toDataAccessProvider() {
        JSONObject dictionary = JsonHelpers.getObject(this.params, "dictionary");
        List<V2Edge> edges = this.getEdges(this.dataJson);
        List<V2Column> columns = this.edgesToColumns(edges);
        List<V2DataRow> rows = this.getRows(this.dataJson, edges, columns, dictionary);
        return new V2DataAccessProvider(new V2MetaData(rows.size(), dictionary, columns), () -> new V2DataIterator(rows));
    }

    private List<V2Edge> getEdges(JSONObject dataJson) {
        JSONArray edgesJson = JsonHelpers.getArray(dataJson, "edges");
        return this.getEdges(edgesJson);
    }

    private List<V2DataRow> getRows(JSONObject dataJson, List<V2Edge> edges, List<V2Column> columns, JSONObject params) {
        JSONArray rowsJson = JsonHelpers.getArray(dataJson, "data");
        return new V2DataParser(rowsJson, edges, columns, params).parseRows();
    }

    private List<V2Edge> getEdges(JSONArray edgesJson) {
        Map<String, String> dataItemIdToLabel = this.getIdsAndLabels();
        ArrayList<V2Edge> edges = new ArrayList<V2Edge>();
        for (int i = 0; i < edgesJson.size(); ++i) {
            edges.add(this.getEdge(JsonHelpers.getObjFromArray(edgesJson, i), dataItemIdToLabel));
        }
        return edges;
    }

    private V2Edge getEdge(JSONObject edge, Map<String, String> dataItemIdToLabel) {
        Map<String, V2Identifier> ids = this.parseIdentifiers(JsonHelpers.getObject(edge, "identifiers"));
        List<V2ItemClass> itemClasses = this.parseItemClassesContainingKnownDataItems(edge, dataItemIdToLabel);
        Tuple<List<V2Item>, Map<Integer, Integer>> items = this.parseKnownItems(JsonHelpers.getArray(edge, "items"), itemClasses, ids);
        return new V2Edge(new ArrayList<V2Identifier>(ids.values()), itemClasses, items);
    }

    private Map<String, V2Identifier> parseIdentifiers(JSONObject identifiersJson) {
        List<String> idKeys = JsonHelpers.keys(identifiersJson);
        return idKeys.stream().collect(Collectors.toMap(Function.identity(), key -> {
            JSONObject idJson = JsonHelpers.getObject(identifiersJson, key);
            return new V2Identifier((String)key, JsonHelpers.getInt(idJson, "ihId"), JsonHelpers.getString(idJson, "d"), JsonHelpers.optString(idJson, "u").orElse(JsonHelpers.getString(idJson, "d")));
        }));
    }

    private List<V2ItemClass> parseItemClassesContainingKnownDataItems(JSONObject edge, Map<String, String> dataItemIdToLabel) {
        JSONArray itemClassesJson = JsonHelpers.getArray(edge, "itemClasses");
        ArrayList<V2ItemClass> itemClasses = new ArrayList<V2ItemClass>();
        for (int i = 0; i < itemClassesJson.size(); ++i) {
            JSONObject itemClassJson = JsonHelpers.getObjFromArray(itemClassesJson, i);
            int itemClassId = JsonHelpers.getInt(itemClassJson, "icId");
            JSONArray headersJson = JsonHelpers.getArray(itemClassJson, "h");
            List<V2Field> fields = this.parseKnownFields(headersJson, dataItemIdToLabel);
            if (fields.isEmpty()) continue;
            itemClasses.add(new V2ItemClass(itemClassId, fields));
        }
        return itemClasses;
    }

    private List<V2Field> parseKnownFields(JSONArray headersJson, Map<String, String> dataItemIdToLabel) {
        ArrayList<V2Field> fields = new ArrayList<V2Field>();
        for (int i = 0; i < headersJson.size(); ++i) {
            JSONObject headerJson = JsonHelpers.getObjFromArray(headersJson, i);
            String dataItemId = JsonHelpers.getString(headerJson, "di");
            if (!dataItemIdToLabel.containsKey(dataItemId) && !this.isComputedStatisticId(dataItemId, dataItemIdToLabel)) {
                return Collections.emptyList();
            }
            fields.add(new V2Field(dataItemId, dataItemIdToLabel.get(dataItemId), this.getAggregationType(headerJson)));
        }
        return fields;
    }

    private Tuple<List<V2Item>, Map<Integer, Integer>> parseKnownItems(JSONArray itemsJson, List<V2ItemClass> itemClasses, Map<String, V2Identifier> identifiers) {
        HashMap<Integer, Integer> indicesMapping = new HashMap<Integer, Integer>();
        ArrayList<V2Item> items = new ArrayList<V2Item>();
        List itemClassIds = itemClasses.stream().map(V2ItemClass::itemClassId).collect(Collectors.toList());
        int remappedItemIndex = 0;
        for (int i = 0; i < itemsJson.size(); ++i) {
            JSONObject itemJson = JsonHelpers.getObjFromArray(itemsJson, i);
            int itemClassId = JsonHelpers.getInt(itemJson, "icId");
            if (!itemClassIds.contains(itemClassId)) continue;
            JSONArray idsJson = JsonHelpers.getArray(itemJson, "t");
            items.add(new V2Item(itemClassId, this.itemIdentifiers(idsJson, identifiers)));
            indicesMapping.put(i, remappedItemIndex++);
        }
        return Tuple.of(items, indicesMapping);
    }

    private List<V2Identifier> itemIdentifiers(JSONArray idsJson, Map<String, V2Identifier> identifiers) {
        ArrayList<V2Identifier> ids = new ArrayList<V2Identifier>();
        for (int k = 0; k < idsJson.size(); ++k) {
            int id = JsonHelpers.getInt(JsonHelpers.getObjFromArray(idsJson, k), "rId");
            ids.add(identifiers.get(Integer.toString(id)));
        }
        return ids;
    }

    private boolean isComputedStatisticId(String dataItemId, Map<String, String> dataItemIdToLabel) {
        if (!dataItemId.startsWith("rowCount:") && !dataItemId.startsWith("sumSqr:")) {
            return false;
        }
        String[] parts = dataItemId.split(":");
        if (parts.length != 2) {
            return false;
        }
        return dataItemIdToLabel.containsKey(parts[1]);
    }

    private List<V2Column> edgesToColumns(List<V2Edge> edges) {
        ArrayList<V2Column> columns = new ArrayList<V2Column>();
        for (V2Edge edge : edges) {
            List<V2ItemClass> itemClasses = edge.itemClasses();
            for (V2ItemClass itemClass : itemClasses) {
                List<V2Item> items = edge.items().stream().filter(item -> item.itemClassId() == itemClass.itemClassId()).collect(Collectors.toList());
                columns.add(new V2Column(itemClass.fields(), items));
            }
        }
        return columns;
    }

    private AggregationType getAggregationType(JSONObject headerJson) {
        String aggType;
        if (!headerJson.containsKey((Object)"aggregate")) {
            return AggregationType.NONE;
        }
        switch (aggType = JsonHelpers.getString(headerJson, "aggregate")) {
            case "none": {
                return AggregationType.NONE;
            }
            case "total": {
                return AggregationType.SUM;
            }
            case "average": {
                return AggregationType.AVERAGE;
            }
            case "minimum": {
                return AggregationType.MINIMUM;
            }
            case "maximum": {
                return AggregationType.MAXIMUM;
            }
            case "count": {
                return AggregationType.COUNT;
            }
            case "countDistinct": {
                return AggregationType.COUNT_DISTINCT;
            }
        }
        return AggregationType.UNKNOWN;
    }

    private Map<String, String> getIdsAndLabels() {
        JSONObject dict = JsonHelpers.getObject(this.params, "dictionary");
        List<String> dataItemIds = JsonHelpers.getStringList(dict, "dataItems");
        List<String> dataItemLabels = JsonHelpers.getStringList(dict, "dataItemLabels");
        LinkedHashMap<String, String> dataItemIdToLabel = new LinkedHashMap<String, String>();
        for (int i = 0; i < dataItemLabels.size(); ++i) {
            dataItemIdToLabel.put(dataItemIds.get(i), dataItemLabels.get(i));
        }
        return dataItemIdToLabel;
    }
}

