/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.endorv2;

import com.ibm.bi.predict.dataaccess.endorv2.V2Column;
import com.ibm.bi.predict.dataaccess.endorv2.V2DataRow;
import com.ibm.bi.predict.dataaccess.endorv2.V2Edge;
import com.ibm.bi.predict.dataaccess.endorv2.V2Field;
import com.ibm.bi.predict.dataaccess.endorv2.V2Item;
import com.ibm.bi.predict.dataaccess.endorv2.V2ItemClass;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.utils.Tuple;
import com.ibm.bi.predict.utils.Tuple3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class V2DataParser {
    private final JSONArray data;
    private final List<V2Edge> edges;
    private final List<V2Column> columns;
    private final List<String> dataItemIds;
    private final List<String> dataItemRoles;
    private final int measuresEdgeIdx;

    public V2DataParser(JSONArray dataRows, List<V2Edge> edges, List<V2Column> columns, JSONObject dictionary) {
        this.data = dataRows;
        this.edges = edges;
        this.columns = columns;
        this.dataItemIds = JsonHelpers.getStringList(dictionary, "dataItems");
        this.dataItemRoles = JsonHelpers.getStringList(dictionary, "roles");
        this.measuresEdgeIdx = this.measuresEdgeIndex();
    }

    public List<V2DataRow> parseRows() {
        LinkedHashMap<Integer, V2DataRow> rows = new LinkedHashMap<Integer, V2DataRow>();
        List<Integer> sizesOfFields = this.sizesOfFields();
        for (int i = 0; i < this.data.size(); ++i) {
            JSONArray row = JsonHelpers.getArray(JsonHelpers.getObjFromArray(this.data, i), "pt");
            if (this.isNonLeafLevelRow(row)) continue;
            int masterIdx = this.getRowIndex(row, sizesOfFields);
            if (!rows.containsKey(masterIdx)) {
                rows.put(masterIdx, new V2DataRow(this.valuesForRow(row)));
                continue;
            }
            if (this.isStatsRow(row, this.measuresEdgeIdx)) {
                Tuple3<Integer, String, Double> statValue = this.statisticValueForRow(row);
                ((V2DataRow)rows.get(masterIdx)).setStatistic((Integer)statValue._1, (String)statValue._2, (Double)statValue._3);
                continue;
            }
            double val = this.getValue(row);
            ((V2DataRow)rows.get(masterIdx)).addValue(val);
        }
        return new ArrayList<V2DataRow>(rows.values());
    }

    private List<Double> valuesForRow(JSONArray row) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int j = 0; j < row.size() - 1; ++j) {
            if (j == this.measuresEdgeIdx) {
                double val = this.getValue(row);
                values.add(val);
                continue;
            }
            int catIdx = (Integer)row.get(j);
            catIdx = this.edges.get(j).mapIndex(catIdx);
            values.add(Double.valueOf(catIdx));
        }
        return values;
    }

    private Tuple3<Integer, String, Double> statisticValueForRow(JSONArray row) {
        int statCatIdx = (Integer)row.get(this.measuresEdgeIdx);
        V2Item item = this.edges.get(this.measuresEdgeIdx).itemByIndex(statCatIdx);
        V2ItemClass itemClass = this.edges.get(this.measuresEdgeIdx).getItemClassById(item.itemClassId());
        String statId = itemClass.fields().get(0).id();
        String measureId = statId.split(":")[1];
        int fieldIdx = IntStream.range(0, this.columns.size()).filter(i -> this.columns.get(i).containsField(measureId)).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find ID of the measure field"));
        Tuple<String, Double> statValue = this.getStatisticValue(row, this.measuresEdgeIdx, statCatIdx);
        return Tuple3.of((Object)fieldIdx, (Object)statValue._1, (Object)statValue._2);
    }

    private boolean isStatsRow(JSONArray row, int measuresIdx) {
        int catIdx = (Integer)row.get(measuresIdx);
        V2Item item = this.edges.get(measuresIdx).itemByIndex(catIdx);
        int itemClassId = item.itemClassId();
        V2ItemClass itemClass = this.edges.get(measuresIdx).getItemClassById(itemClassId);
        if (itemClass.fields().size() != 1) {
            return false;
        }
        String fieldId = itemClass.fields().get(0).id();
        return fieldId.startsWith("rowCount:") || fieldId.startsWith("sumSqr:");
    }

    private double getValue(JSONArray arr) {
        JSONObject valObj = JsonHelpers.getObjFromArray(arr, arr.size() - 1);
        return JsonHelpers.getDouble(valObj, "v");
    }

    private boolean isNonLeafLevelRow(JSONArray row) {
        for (int i = 0; i < row.size() - 1; ++i) {
            int catIdx = (Integer)row.get(i);
            if (!this.edges.get(i).hasItem(catIdx)) {
                return true;
            }
            V2Item item = this.edges.get(i).itemByIndex(catIdx);
            List itemClassFields = this.edges.get(i).itemClasses().stream().filter(ic -> ic.itemClassId() == item.itemClassId()).map(V2ItemClass::fields).findFirst().orElse(Collections.emptyList());
            if (itemClassFields.isEmpty()) {
                return true;
            }
            for (V2Field field : itemClassFields) {
                String fieldId = field.id();
                if (fieldId.startsWith("rowCount:") || fieldId.startsWith("sumSqr:")) {
                    fieldId = fieldId.split(":")[1];
                }
                if (this.dataItemIds.contains(fieldId)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Integer> sizesOfFields() {
        ArrayList<Integer> sizesOfItems = new ArrayList<Integer>();
        for (int edgeIdx : this.nonResponseIndices()) {
            sizesOfItems.add(this.edges.get(edgeIdx).items().size());
        }
        return sizesOfItems;
    }

    private int getRowIndex(JSONArray row, List<Integer> sizesOfFields) {
        ArrayList<Integer> rowIndices = new ArrayList<Integer>();
        for (int edgeIdx : this.nonResponseIndices()) {
            int catIdx = (Integer)row.get(edgeIdx);
            rowIndices.add(catIdx);
        }
        return V2DataParser.indicesToIndex(rowIndices, sizesOfFields);
    }

    private static int indicesToIndex(List<Integer> indices, List<Integer> sizes) {
        int idx = 0;
        for (int i = indices.size() - 1; i >= 0; --i) {
            int mult = 1;
            for (int j = 0; j < i; ++j) {
                mult *= sizes.get(j).intValue();
            }
            idx += indices.get(i) * mult;
        }
        return idx;
    }

    private List<Integer> nonResponseIndices() {
        return IntStream.range(0, this.edges.size()).filter(i -> i != this.measuresEdgeIdx).boxed().collect(Collectors.toList());
    }

    private int measuresEdgeIndex() {
        List<Integer> responseIndices = this.edgeIndicesByRole("response");
        if (responseIndices.size() != 1) {
            throw new IllegalStateException("Expected to find single measures edge. Found: " + responseIndices.size());
        }
        return responseIndices.get(0);
    }

    private List<Integer> edgeIndicesByRole(String role) {
        List dataItemIdsByRole = IntStream.range(0, this.dataItemRoles.size()).filter(i -> role.equals(this.dataItemRoles.get(i))).mapToObj(this.dataItemIds::get).collect(Collectors.toList());
        LinkedHashSet<Integer> edgeIndices = new LinkedHashSet<Integer>();
        for (String id : dataItemIdsByRole) {
            for (int i2 = 0; i2 < this.edges.size(); ++i2) {
                if (!this.edgeContainsDataItem(this.edges.get(i2), id)) continue;
                edgeIndices.add(i2);
            }
        }
        return new ArrayList<Integer>(edgeIndices);
    }

    private boolean edgeContainsDataItem(V2Edge edge, String dataItemId) {
        for (V2ItemClass itemClass : edge.itemClasses()) {
            for (V2Field field : itemClass.fields()) {
                if (!dataItemId.equals(field.id())) continue;
                return true;
            }
        }
        return false;
    }

    private Tuple<String, Double> getStatisticValue(JSONArray row, int edgeIdx, int catIdx) {
        double statValue = this.getValue(row);
        V2Item item = this.edges.get(edgeIdx).itemByIndex(catIdx);
        int itemClassId = item.itemClassId();
        V2ItemClass itemClass = this.edges.get(edgeIdx).getItemClassById(itemClassId);
        if (itemClass.fields().size() != 1) {
            throw new IllegalStateException("Expected statistics item class to have one field");
        }
        String fieldId = itemClass.fields().get(0).id();
        String[] parts = fieldId.split(":");
        return Tuple.of((Object)parts[0], (Object)statValue);
    }
}

