/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.endorv2;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.utils.Tuple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class V2DataRow
implements DataRow {
    private final Map<Tuple<Integer, String>, Double> statistics = new HashMap<Tuple<Integer, String>, Double>();
    private final List<Double> vals;

    public V2DataRow(List<Double> vals) {
        this(vals, new HashMap<Integer, Map<String, Double>>());
    }

    public V2DataRow(List<Double> vals, Map<Integer, Map<String, Double>> stats) {
        this.vals = vals;
        for (Map.Entry<Integer, Map<String, Double>> entry : stats.entrySet()) {
            for (Map.Entry<String, Double> kv : entry.getValue().entrySet()) {
                this.setStatistic(entry.getKey(), kv.getKey(), kv.getValue());
            }
        }
    }

    @Override
    public double getValue(int columnIndex) {
        return this.vals.get(columnIndex);
    }

    @Override
    public double getStatistic(String statisticName, int columnIndex) {
        return this.statistics.get(Tuple.of((Object)columnIndex, (Object)statisticName));
    }

    public void setStatistic(int columnIndex, String statisticName, double val) {
        this.statistics.put((Tuple<Integer, String>)Tuple.of((Object)columnIndex, (Object)statisticName), val);
    }

    public void addValue(double val) {
        this.vals.add(val);
    }

    public int hashCode() {
        return Objects.hash(this.vals, this.statistics);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof V2DataRow)) {
            return false;
        }
        V2DataRow other = (V2DataRow)obj;
        return Objects.equals(this.vals, other.vals) && Objects.equals(this.statistics, other.statistics);
    }
}

