/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.endorv2;

import com.ibm.bi.predict.dataaccess.endorv2.V2Identifier;
import com.ibm.bi.predict.dataaccess.endorv2.V2Item;
import com.ibm.bi.predict.dataaccess.endorv2.V2ItemClass;
import com.ibm.bi.predict.utils.Tuple;
import java.util.List;
import java.util.Map;

public class V2Edge {
    private final List<V2Identifier> identifiers;
    private final List<V2ItemClass> itemClasses;
    private final List<V2Item> items;
    private final Map<Integer, Integer> indicesMapping;

    public V2Edge(List<V2Identifier> identifiers, List<V2ItemClass> itemClasses, Tuple<List<V2Item>, Map<Integer, Integer>> items) {
        this.identifiers = identifiers;
        this.itemClasses = itemClasses;
        this.items = (List)items._1;
        this.indicesMapping = (Map)items._2;
    }

    public V2ItemClass getItemClassById(int id) {
        return this.itemClasses.stream().filter(ic -> ic.itemClassId() == id).findFirst().orElse(null);
    }

    public List<V2Identifier> identifiers() {
        return this.identifiers;
    }

    public List<V2ItemClass> itemClasses() {
        return this.itemClasses;
    }

    public List<V2Item> items() {
        return this.items;
    }

    public V2Item itemByIndex(int idx) {
        int newIdx = this.indicesMapping.get(idx);
        return this.items.get(newIdx);
    }

    public boolean hasItem(int idx) {
        return this.indicesMapping.containsKey(idx);
    }

    public int mapIndex(int idx) {
        return this.indicesMapping.get(idx);
    }
}

