/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class DataJsonParser {
    private static final String COLUMNS_ARRAY_KEY = "dataItems";
    private static final String ROWS_ARRAY_KEY = "data";
    private static final String COLUMN_DATA_KEY = "itemClass";
    private static final String CLIPPED_DATA_KEY = "hasNext";
    private final JSONObject inputData;

    public DataJsonParser(JSONObject inputData) {
        this.inputData = inputData;
    }

    public JSONArray getColumnsArray() {
        try {
            return this.inputData.getJSONArray(COLUMNS_ARRAY_KEY);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent columns array", e);
        }
    }

    public JSONObject getColumnObject(int fieldIdx) {
        try {
            return this.getColumnsArray().getJSONObject(fieldIdx);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent column", e);
        }
    }

    public String getColumnId(int columnIdx) {
        try {
            JSONObject field = this.getColumnObject(columnIdx);
            JSONObject itemClass = field.getJSONObject(COLUMN_DATA_KEY);
            return itemClass.getString("id");
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent column id", e);
        }
    }

    public JSONArray getRowsArray() {
        try {
            return this.inputData.getJSONArray(ROWS_ARRAY_KEY);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent rows array", e);
        }
    }

    public boolean isClippedData() {
        try {
            boolean existsClippedData = this.inputData.containsKey((Object)CLIPPED_DATA_KEY);
            if (existsClippedData) {
                return this.inputData.getBoolean(CLIPPED_DATA_KEY);
            }
            return false;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent clipped data", e);
        }
    }
}

