/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.DataJsonParser;
import com.ibm.bi.predict.dataaccess.json.JsonDataIterator;
import com.ibm.bi.predict.dataaccess.json.JsonDecorator;
import com.ibm.bi.predict.dataaccess.json.JsonMetaData;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonDataAccessProvider
implements DataAccessProvider {
    private final JsonMetaData metadata;
    private JSONObject inputData;
    private DataJsonParser parser;

    public JsonDataAccessProvider(JSONObject inputData) {
        this(inputData, Collections.emptyMap(), Collections.emptyMap());
    }

    public JsonDataAccessProvider(JSONObject inputData, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        this(inputData, Collections.emptyMap(), conceptsMap);
    }

    public JsonDataAccessProvider(JSONObject inputData, Map<String, String> fieldIdToDataType, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        this.inputData = inputData;
        this.parser = new DataJsonParser(inputData);
        this.metadata = new JsonMetaData(this.parser, fieldIdToDataType, conceptsMap);
    }

    @Override
    public DataIterator getDataIterator() {
        try {
            return new JsonDataIterator(this.inputData.getJSONArray("data"), this.parser);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent iterator", e);
        }
    }

    @Override
    public Decorator getDecorator() {
        return new JsonDecorator(this.inputData);
    }

    @Override
    public MetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public void close() {
        this.inputData = null;
        this.parser = null;
    }

    public boolean isReleased() {
        return this.inputData == null && this.parser == null;
    }
}

