/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.DataJsonParser;
import com.ibm.bi.predict.dataaccess.json.JsonDataRow;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonDataIterator
implements DataIterator {
    private final DataJsonParser parser;
    private final JSONArray data;
    private Iterator<?> dataIterator;

    public JsonDataIterator(JSONArray data, DataJsonParser parser) {
        this.parser = parser;
        this.data = data;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.dataIterator.hasNext();
    }

    @Override
    public DataRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        JSONArray rowArray = this.getNextRow();
        return new JsonDataRow(this.parser, rowArray);
    }

    @Override
    public void reset() {
        this.dataIterator = this.data != null ? this.data.iterator() : Collections.emptyIterator();
    }

    private JSONArray getNextRow() {
        try {
            Object next = this.dataIterator.next();
            if (!(next instanceof JSONObject)) {
                throw new IllegalArgumentException("Expected JSON object");
            }
            JSONObject dataObj = (JSONObject)JSONObject.class.cast(next);
            if (!dataObj.containsKey((Object)"pt")) {
                throw new IllegalArgumentException("Missing 'pt' key from data object");
            }
            return dataObj.getJSONArray("pt");
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent row", e);
        }
    }
}

