/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.DataJsonParser;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonDataRow
implements DataRow {
    private static final Logger logger = PredictLoggerFactory.getLogger(JsonDataRow.class);
    private JSONArray rowArray;
    private DataJsonParser parser;

    public JsonDataRow(DataJsonParser parser, JSONArray rowArray) {
        this.parser = parser;
        this.rowArray = rowArray;
    }

    @Override
    public double getValue(int columnIndex) {
        if (columnIndex >= this.rowArray.size() || columnIndex < 0) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent column index");
        }
        Object o = this.rowArray.get(columnIndex);
        return this.extractValue(o).doubleValue();
    }

    @Override
    public double getStatistic(String statisticName, int columnIndex) {
        try {
            String statisticId = this.createStatisticId(statisticName, columnIndex);
            int statisticColumnIdx = this.getStatisticColumnIdx(statisticId);
            return this.getValue(statisticColumnIdx);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest("Attempting to access non-existent column index", e);
        }
    }

    private Number extractValue(Object o) {
        if (o instanceof Number) {
            return this.extractCategoryIndex(o);
        }
        if (o instanceof JSONObject) {
            return this.extractContinuousValue(o);
        }
        return Double.NaN;
    }

    private Number extractCategoryIndex(Object o) {
        return ((Number)o).intValue();
    }

    private Number extractContinuousValue(Object o) {
        try {
            JSONObject obj = (JSONObject)o;
            if (!obj.containsKey((Object)"v") || !(obj.get("v") instanceof Number)) {
                return Double.NaN;
            }
            Double numValue = obj.getDouble("v");
            return numValue;
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest("Attempting to access non-existent value", e);
        }
    }

    private String createStatisticId(String statisticName, int columnIdx) {
        String fieldId = this.parser.getColumnId(columnIdx);
        return statisticName + ":" + fieldId;
    }

    private int getStatisticColumnIdx(String statisticId) {
        JSONArray columnsArr = this.parser.getColumnsArray();
        for (int i = 0; i < columnsArr.size(); ++i) {
            String columnId = this.parser.getColumnId(i);
            if (!statisticId.equals(columnId)) continue;
            return i;
        }
        return -1;
    }
}

