/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonDecorator
implements Decorator {
    private JSONObject inputData;
    private static final String DECORATION_KEY = "deco";
    private static final String CANNOT_DECORATE_MSG = "Cannot decorate cell";
    private static final String ITEMS_KEY = "items";
    private static final String DATAITEMS_KEY = "dataItems";
    private static final String DATA_KEY = "data";
    private static final String PT_KEY = "pt";

    public JsonDecorator(JSONObject inputData) {
        this.inputData = inputData;
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, Boolean value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateCell(columnIdx, rowIdx, deco);
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, String value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateCell(columnIdx, rowIdx, deco);
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, String[] value) {
        try {
            JSONObject deco = JsonHelpers.makeObj(key, (Object)new JSONArray(Arrays.asList(value)));
            this.doDecorateCell(columnIdx, rowIdx, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest(CANNOT_DECORATE_MSG, e);
        }
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, String[][] value) {
        try {
            JSONArray arrayArray = new JSONArray();
            for (String[] array : value) {
                arrayArray.add((Object)new JSONArray(Arrays.asList(array)));
            }
            JSONObject deco = JsonHelpers.makeObj(key, (Object)arrayArray);
            this.doDecorateCell(columnIdx, rowIdx, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest(CANNOT_DECORATE_MSG, e);
        }
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, Number value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateCell(columnIdx, rowIdx, deco);
    }

    @Override
    public void decorateCell(int columnIdx, int rowIdx, String key, Number[] value) {
        try {
            JSONObject deco = JsonHelpers.makeObj(key, (Object)new JSONArray(Arrays.asList(value)));
            this.doDecorateCell(columnIdx, rowIdx, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest(CANNOT_DECORATE_MSG, e);
        }
    }

    @Override
    public void decorateColumn(int columnIdx, String key, Boolean value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateColumn(columnIdx, deco);
    }

    @Override
    public void decorateColumn(int columnIdx, String key, String value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateColumn(columnIdx, deco);
    }

    @Override
    public void decorateColumn(int columnIdx, String key, String[] value) {
        try {
            JSONObject deco = JsonHelpers.makeObj(key, (Object)new JSONArray(Arrays.asList(value)));
            this.doDecorateColumn(columnIdx, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Cannot decorate column", e);
        }
    }

    @Override
    public void decorateColumn(int columnIdx, String key, Number value) {
        JSONObject deco = JsonHelpers.makeObj(key, (Object)value);
        this.doDecorateColumn(columnIdx, deco);
    }

    @Override
    public void decorateColumn(int columnIdx, String key, Number[] array) {
        try {
            JSONObject deco = JsonHelpers.makeObj(key, (Object)new JSONArray(Arrays.asList(array)));
            this.doDecorateColumn(columnIdx, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Cannot decorate column", e);
        }
    }

    @Override
    public void decorateGlobal(String key, Boolean value) {
        this.doDecorateGlobal(key, value);
    }

    @Override
    public void decorateGlobal(String key, String value) {
        this.doDecorateGlobal(key, value);
    }

    @Override
    public void decorateGlobal(String key, String[] array) {
        try {
            this.doDecorateGlobal(key, new JSONArray(Arrays.asList(array)));
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Cannot decorate global", e);
        }
    }

    @Override
    public void decorateGlobal(String key, Number value) {
        this.doDecorateGlobal(key, value);
    }

    @Override
    public void decorateGlobal(String key, Number[] array) {
        try {
            this.doDecorateGlobal(key, new JSONArray(Arrays.asList(array)));
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Cannot decorate global", e);
        }
    }

    @Override
    public int addDataRow(Number[] data) {
        try {
            JSONArray newRow = new JSONArray();
            for (Number val : data) {
                if (val instanceof Integer) {
                    newRow.add((Object)val);
                    continue;
                }
                if (val instanceof Double) {
                    JSONObject valueObject = JsonHelpers.makeObj("v", (Object)val);
                    newRow.add((Object)valueObject);
                    continue;
                }
                throw new IllegalArgumentException("Found invalid type in data array");
            }
            JSONObject rowObj = JsonHelpers.makeObj(PT_KEY, (Object)newRow);
            JSONArray dataArray = this.inputData.getJSONArray(DATA_KEY);
            dataArray.add((Object)rowObj);
            return dataArray.size() - 1;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent array", e);
        }
    }

    @Override
    public void addCategory(int columnIndex, String[] displayLabels, String[] uniqueIds) {
        try {
            if (displayLabels.length != uniqueIds.length) {
                throw new IllegalArgumentException("Found displaylabel and uniqueId arrays not the same size");
            }
            JSONArray dataItems = this.inputData.getJSONArray(DATAITEMS_KEY).getJSONObject(columnIndex).getJSONArray(ITEMS_KEY);
            dataItems.add((Object)JsonHelpers.makeDataItemObject(displayLabels, uniqueIds));
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent array", e);
        }
    }

    @Override
    public boolean reorderRows(int columnIdx, int[] rowOrder) {
        if (this.isOrdered(rowOrder)) {
            return false;
        }
        try {
            JSONArray sortedRows = this.sortRows(this.columnRows(columnIdx), rowOrder);
            this.column(columnIdx).put(ITEMS_KEY, (Collection)sortedRows);
            this.updateDataRowIndices(columnIdx, rowOrder);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to sort column", e);
        }
        return true;
    }

    private boolean isOrdered(int[] rowOrder) {
        return IntStream.range(0, rowOrder.length).allMatch(i -> rowOrder[i] == i);
    }

    private void updateDataRowIndices(int columnIdx, int[] rowOrder) throws JSONException {
        Map<Integer, Integer> indexMap = this.makeRowIndexMap(rowOrder);
        JSONArray dataArray = this.inputData.getJSONArray(DATA_KEY);
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONArray dataPoint = dataArray.getJSONObject(i).getJSONArray(PT_KEY);
            dataPoint.set(columnIdx, (Object)indexMap.get(dataPoint.get(columnIdx)));
        }
    }

    private Map<Integer, Integer> makeRowIndexMap(int[] rowOrder) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < rowOrder.length; ++i) {
            indexMap.put(rowOrder[i], i);
        }
        return indexMap;
    }

    private JSONArray sortRows(JSONArray rows, int[] rowOrder) {
        if (rowOrder.length != rows.length()) {
            throw new IllegalArgumentException("Unexpected discrepancy during sorting, row order and row lengths do not match.");
        }
        JSONArray sortedRows = new JSONArray();
        for (int i = 0; i < rowOrder.length; ++i) {
            sortedRows.add(rows.get(rowOrder[i]));
        }
        return sortedRows;
    }

    private JSONObject column(int columnIdx) throws JSONException {
        return this.inputData.getJSONArray(DATAITEMS_KEY).getJSONObject(columnIdx);
    }

    private JSONArray columnRows(int columnIdx) throws JSONException {
        return this.column(columnIdx).getJSONArray(ITEMS_KEY);
    }

    private void doDecorateCell(int columnIdx, int rowIdx, JSONObject deco) {
        try {
            JSONObject target = this.inputData.getJSONArray(DATA_KEY).getJSONObject(rowIdx);
            this.makeOrAddDecoration(target, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent cell", e);
        }
    }

    private void doDecorateColumn(int columnIdx, JSONObject deco) {
        try {
            JSONObject target = this.inputData.getJSONArray(DATAITEMS_KEY).getJSONObject(columnIdx);
            this.makeOrAddDecoration(target, deco);
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent column", e);
        }
    }

    private void doDecorateGlobal(String key, Object value) {
        JSONObject deco = JsonHelpers.makeObj(key, value);
        this.makeOrAddDecoration(this.inputData, deco);
    }

    private void makeOrAddDecoration(JSONObject target, JSONObject deco) {
        try {
            boolean existsDeco = target.containsKey((Object)DECORATION_KEY);
            if (!existsDeco) {
                target.put(DECORATION_KEY, (Map)deco);
            } else {
                JSONObject object = target.getJSONObject(DECORATION_KEY);
                HashSet<Map.Entry> entrySet = new HashSet<Map.Entry>();
                for (Object entry : deco.entrySet()) {
                    entrySet.add((Map.Entry)entry);
                }
                for (Map.Entry e : entrySet) {
                    object.put((String)e.getKey(), e.getValue());
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Cannot make or add decoration", e);
        }
    }
}

