/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.json;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.DataJsonParser;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonMetaData
implements MetaData {
    private static final Logger LOG = PredictLoggerFactory.getLogger(JsonMetaData.class);
    private static final String EMPTY_CATEGORY_LABEL = "PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT";
    private static final String ITEMS_KEY = "items";
    private DataJsonParser parser;
    private Map<String, String> fieldIdToDataType;
    private Map<String, List<Tuple<String, Double>>> conceptsMap;
    private final Map<Integer, List<String>> displayLabels = new HashMap<Integer, List<String>>();
    private final Map<Integer, JSONArray> categoriesByColumnIndex = new HashMap<Integer, JSONArray>();
    private final Map<Tuple<Integer, Integer>, String> categoryLabels = new HashMap<Tuple<Integer, Integer>, String>();

    public JsonMetaData(DataJsonParser parser) {
        this(parser, Collections.emptyMap(), Collections.emptyMap());
    }

    public JsonMetaData(DataJsonParser parser, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        this(parser, Collections.emptyMap(), conceptsMap);
    }

    public JsonMetaData(DataJsonParser parser, Map<String, String> fieldIdToDataType, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        this.parser = parser;
        this.fieldIdToDataType = fieldIdToDataType;
        this.conceptsMap = conceptsMap;
    }

    @Override
    public int fieldCount() {
        return this.columns().size();
    }

    @Override
    public int getFieldCategories(int columnIdx) {
        return this.categoriesByColumnIndex.computeIfAbsent(columnIdx, v -> this.columnCategories(columnIdx)).size();
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        return this.categoryLabels.computeIfAbsent((Tuple<Integer, Integer>)Tuple.of((Object)columnIndex, (Object)categoryIndex), v -> this.categoryDisplayLabel(this.columnCategory(columnIndex, categoryIndex)));
    }

    @Override
    public List<String> getFieldCategoryLabels(int columnIndex, int categoryIndex) {
        return this.categoryDisplayLabels(this.columnCategory(columnIndex, categoryIndex));
    }

    @Override
    public String getFieldCategoryIdentifier(int columnIndex, int categoryIndex) {
        return this.categoryUniqueId(this.columnCategory(columnIndex, categoryIndex));
    }

    @Override
    public String getFieldIdentifier(int columnIdx) {
        return this.columnId(this.column(columnIdx));
    }

    @Override
    public List<String> getFieldIdentifiers(int columnIdx) {
        JSONObject field = this.column(columnIdx);
        ArrayList<String> ids = new ArrayList<String>();
        if (this.subFieldSize(columnIdx) == 1) {
            return Collections.singletonList(this.columnId(field));
        }
        for (int i = 0; i < this.subFieldSize(columnIdx); ++i) {
            ids.add(this.columnId(this.subField(field, i)));
        }
        return ids;
    }

    @Override
    public String getFieldDisplayLabel(int columnIdx) {
        List<String> labels = this.getFieldDisplayLabels(columnIdx);
        if (labels.isEmpty()) {
            return this.getFieldIdentifier(columnIdx);
        }
        return String.join((CharSequence)" - ", labels);
    }

    @Override
    public List<Tuple<String, Double>> getConcepts(int columnIdx) {
        String fieldId = this.getFieldUniqueId(columnIdx);
        if (this.conceptsMap.containsKey(fieldId)) {
            return this.conceptsMap.get(fieldId);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> getUniqueIdentifiersMap(int columnIdx) {
        JSONObject field = this.column(columnIdx);
        HashMap<String, String> uidMap = new HashMap<String, String>();
        try {
            JSONArray headers = field.getJSONArray("h");
            for (int i = 0; i < headers.size(); ++i) {
                JSONObject header = headers.getJSONObject(i);
                if (header.containsKey((Object)"id")) {
                    uidMap.put(header.getString("id"), header.getString("u"));
                    continue;
                }
                uidMap.put(this.columnId(field), header.getString("u"));
            }
        }
        catch (JSONException e) {
            LOG.debug("Failed to construct map of field IDs to unique IDs.");
            return Collections.emptyMap();
        }
        return uidMap;
    }

    @Override
    public Map<String, List<Tuple<String, Double>>> getConceptsMap() {
        return this.conceptsMap;
    }

    @Override
    public List<String> getFieldDisplayLabels(int columnIdx) {
        return this.displayLabels.computeIfAbsent(columnIdx, v -> {
            JSONObject field = this.column(columnIdx);
            ArrayList<String> labels = new ArrayList<String>();
            for (int i = 0; i < this.subFieldSize(columnIdx); ++i) {
                String label = this.displayLabel(this.subField(field, i));
                if (label != null) {
                    labels.add(label);
                    continue;
                }
                labels.add(this.getFieldIdentifier(columnIdx));
            }
            return labels;
        });
    }

    @Override
    public FieldType getFieldType(int columnIdx) {
        String datatype = this.fieldIdToDataType.get(this.getFieldIdentifier(columnIdx));
        if (datatype != null) {
            return FieldType.fromString((String)datatype);
        }
        JSONObject field = this.parser.getColumnObject(columnIdx);
        if (field.containsKey((Object)ITEMS_KEY)) {
            return FieldType.CATEGORICAL;
        }
        return FieldType.NUMERICAL;
    }

    @Override
    public StatisticStatus getStatisticStatus(String statisticName, int columnIdx) {
        try {
            String statisticId = this.createStatisticId(statisticName, columnIdx);
            return this.hasStatistic(statisticId) ? StatisticStatus.AVAILABLE : StatisticStatus.UNAVAILABLE;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    @Override
    public int rowCount() {
        return this.parser.getRowsArray().size();
    }

    @Override
    public AggregationType getFieldAggregation(int columnIdx) {
        JSONObject subField;
        String aggregationType;
        AggregationType type;
        if (this.subFieldSize(columnIdx) != 1) {
            LOG.warn("Trying to get single aggregation of stacked field - numStacked={}", (Object)this.subFieldSize(columnIdx));
        }
        if ((type = AggregationType.fromString((String)(aggregationType = (subField = this.subField(this.column(columnIdx), 0)).optString("aggregate")))) == null) {
            throw new IllegalDataAccessRequest("Invalid aggregation type:" + aggregationType);
        }
        return type;
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIdx, int categoryIndex) {
        return this.categoryAggregations(this.columnCategory(columnIdx, categoryIndex));
    }

    @Override
    public boolean isClippedData() {
        return this.parser.isClippedData();
    }

    @Override
    public int itemsInField(int columnIdx) {
        return this.subFieldSize(columnIdx);
    }

    @Override
    public List<String> getFieldCategoryIdentifiers(int columnIdx, int categoryIndex) {
        return this.categoryUniqueIds(this.columnCategory(columnIdx, categoryIndex));
    }

    @Override
    public void setConcepts(Map<String, List<Tuple<String, Double>>> concepts) {
        this.conceptsMap = new HashMap<String, List<Tuple<String, Double>>>(concepts);
    }

    private JSONObject column(int columnIdx) {
        if (columnIdx < 0 || columnIdx >= this.fieldCount()) {
            throw new IllegalDataAccessRequest("Invalid column index: " + columnIdx);
        }
        try {
            return this.parser.getColumnObject(columnIdx).getJSONObject("itemClass");
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private JSONArray columnCategories(int columnIdx) {
        if (columnIdx < 0 || columnIdx >= this.fieldCount()) {
            throw new IllegalDataAccessRequest("Invalid column index: " + columnIdx);
        }
        JSONObject field = this.parser.getColumnObject(columnIdx);
        if (!field.containsKey((Object)ITEMS_KEY)) {
            throw new IllegalDataAccessRequest("Attempting to access categories on non-categorical field");
        }
        try {
            return field.getJSONArray(ITEMS_KEY);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private JSONObject columnCategory(int columnIdx, int categoryIdx) {
        try {
            JSONArray categories = this.columnCategories(columnIdx);
            if (categoryIdx < 0 || categoryIdx >= categories.size()) {
                throw new IllegalDataAccessRequest("Invalid category index: " + categoryIdx);
            }
            return categories.getJSONObject(categoryIdx);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private JSONArray columns() {
        return this.parser.getColumnsArray();
    }

    private String columnId(JSONObject column) {
        String id = column.optString("id", column.optString("u", column.optString("d")));
        if (id == null) {
            throw new IllegalDataAccessRequest("All of the id, u, and d properties of an itemClass are null");
        }
        return id;
    }

    private String displayLabel(JSONObject column) {
        try {
            if (column.isNull("d")) {
                return null;
            }
            return column.getString("d");
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private String createStatisticId(String statisticName, int columnIdx) {
        String fieldId = this.parser.getColumnId(columnIdx);
        return statisticName + ":" + fieldId;
    }

    private boolean hasStatistic(String statisticId) {
        for (int i = 0; i < this.columns().size(); ++i) {
            String fieldId = this.parser.getColumnId(i);
            if (!statisticId.equals(fieldId)) continue;
            return true;
        }
        return false;
    }

    private int subFieldSize(int columnIdx) {
        try {
            JSONObject field = this.column(columnIdx);
            return field.getJSONArray("h").size();
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private JSONObject subField(JSONObject column, int subFieldIndex) {
        try {
            return column.getJSONArray("h").getJSONObject(subFieldIndex);
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private String categoryUniqueId(JSONObject category) {
        return Optional.ofNullable(this.categoryUniqueIds(category).get(0)).orElse(this.categoryDisplayLabels(category).get(0));
    }

    private String categoryDisplayLabel(JSONObject category) {
        return String.join((CharSequence)"|", this.categoryDisplayLabels(category));
    }

    private List<String> categoryUniqueIds(JSONObject category) {
        try {
            JSONArray catObjs = category.getJSONArray("t");
            ArrayList<String> categoryUniqueIds = new ArrayList<String>();
            for (int i = 0; i < catObjs.size(); ++i) {
                String uniqueId = catObjs.getJSONObject(i).optString("u");
                categoryUniqueIds.add(uniqueId);
            }
            return categoryUniqueIds;
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private List<String> categoryDisplayLabels(JSONObject category) {
        try {
            JSONArray catObjs = category.getJSONArray("t");
            ArrayList<String> categoryLabels = new ArrayList<String>();
            for (int i = 0; i < catObjs.size(); ++i) {
                JSONObject catObj = catObjs.getJSONObject(i);
                String label = null;
                if (catObj.containsKey((Object)"d")) {
                    label = catObj.optString("d");
                } else if (catObj.containsKey((Object)"u")) {
                    label = catObj.optString("u");
                }
                if (label == null) {
                    label = EMPTY_CATEGORY_LABEL;
                }
                categoryLabels.add(label);
            }
            return categoryLabels;
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private List<AggregationType> categoryAggregations(JSONObject category) {
        try {
            ArrayList<AggregationType> categoryAggregations = new ArrayList<AggregationType>();
            JSONArray catObjs = category.getJSONArray("t");
            for (int i = 0; i < catObjs.size(); ++i) {
                String aggregate = category.getJSONArray("t").getJSONObject(i).optString("aggregate");
                categoryAggregations.add(AggregationType.fromString((String)aggregate));
            }
            return categoryAggregations;
        }
        catch (JSONException e) {
            LOG.error("Error while getting field category aggregation - reason = {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalDataAccessRequest(e.getMessage(), e);
        }
    }

    private String getFieldUniqueId(int columnIdx) {
        try {
            JSONObject field = this.column(columnIdx);
            return field.getJSONArray("h").getJSONObject(0).getString("u");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

