/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDataAccessProvider;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDimension;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatSeriesHierarchy;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JsonStat {
    public static final Set<String> SUPPORTED_VERSIONS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"2.0"}));
    public static final String VERSION = "2.0";
    public static final String VERSION_KEY = "version";
    public static final String ID_KEY = "id";
    public static final String SIZE_KEY = "size";
    public static final String VALUE_KEY = "value";
    public static final String TIME_KEY = "time";
    public static final String METRIC_KEY = "metric";
    public static final String ROLE_KEY = "role";
    public static final String CATEGORY_KEY = "category";
    public static final Object INDEX_KEY = "index";
    public static final String DIMENSION_KEY = "dimension";
    private final double[] data;
    private JsonStatTime time;
    private JsonStatSeriesHierarchy seriesHierarchy;

    public JsonStat(JSONObject jsonStat) {
        this.time = JsonStat.buildTime(jsonStat);
        this.seriesHierarchy = JsonStat.buildForecastingHierarchy(jsonStat);
        this.data = this.buildData(jsonStat);
    }

    private double[] buildData(JSONObject jsonStat) {
        double[] inputValueArray = JsonStat.getValueArray(jsonStat);
        double[] outputDataArray = new double[inputValueArray.length];
        int[] sizeArray = JsonStat.getSizeArray(jsonStat);
        int[] fieldIncrement = JsonStat.getFieldIncrements(sizeArray);
        int[] dimIndexMap = this.getDimIndexMap();
        int[] newSizeArray = new int[dimIndexMap.length];
        for (int newIndex = 0; newIndex < dimIndexMap.length; ++newIndex) {
            newSizeArray[newIndex] = sizeArray[dimIndexMap[newIndex]];
        }
        int[] newPos = new int[newSizeArray.length];
        for (int i = 0; i < inputValueArray.length; ++i) {
            int[] pos = JsonStat.getPos(i, fieldIncrement);
            for (int j = 0; j < newSizeArray.length; ++j) {
                newPos[j] = pos[dimIndexMap[j]];
            }
            int newOrdinal = this.getOrdinal(newPos, JsonStat.getFieldIncrements(newSizeArray));
            outputDataArray[newOrdinal] = inputValueArray[i];
        }
        return outputDataArray;
    }

    private int[] getDimIndexMap() {
        JsonStatDimension[] timeDims = this.time.getDimensions();
        JsonStatDimension[] seriesDims = this.seriesHierarchy.getDims();
        int[] dimIndexMap = new int[timeDims.length + seriesDims.length];
        int newIndex = 0;
        for (JsonStatDimension dim : timeDims) {
            dimIndexMap[newIndex] = dim.getIndex();
            ++newIndex;
        }
        for (JsonStatDimension dim : seriesDims) {
            dimIndexMap[newIndex] = dim.getIndex();
            ++newIndex;
        }
        return dimIndexMap;
    }

    private int getOrdinal(int[] pos, int[] fieldIncrement) {
        int value = 0;
        for (int i = 0; i < fieldIncrement.length; ++i) {
            value += pos[i] * fieldIncrement[i];
        }
        return value;
    }

    private static int[] getFieldIncrements(int[] siezArray) {
        int[] fieldIncrement = new int[siezArray.length];
        for (int fieldIndex = 0; fieldIndex < siezArray.length; ++fieldIndex) {
            fieldIncrement[fieldIndex] = 1;
            for (int j = fieldIndex + 1; j < siezArray.length; ++j) {
                int n = fieldIndex;
                fieldIncrement[n] = fieldIncrement[n] * siezArray[j];
            }
        }
        return fieldIncrement;
    }

    private static int[] getPos(int ordinal, int[] fieldIncrement) {
        int[] indices = new int[fieldIncrement.length];
        for (int i = 0; i < fieldIncrement.length; ++i) {
            indices[i] = ordinal / fieldIncrement[i];
            ordinal %= fieldIncrement[i];
        }
        return indices;
    }

    public JsonStat(String jsonStatString) throws JSONException {
        this(new JSONObject(jsonStatString));
    }

    public JsonStat(DataAccessProvider provider, String timeId, JSONObject hierarchy) throws JSONException {
        int[] dataIndices = JsonStat.getDataIndices(provider, hierarchy);
        this.time = JsonStat.buildTime(provider, timeId);
        this.data = JsonStat.getValueArray(provider, dataIndices);
        Set metrics = hierarchy.getJSONObject(DIMENSION_KEY).keySet();
        this.seriesHierarchy = new JsonStatSeriesHierarchy(JsonStat.getDimension(hierarchy, (String)metrics.iterator().next(), 1));
    }

    public JsonStat(double[] data, JsonStatTime time, JsonStatSeriesHierarchy seriesHierarchy) {
        this.data = data;
        this.time = time;
        this.seriesHierarchy = seriesHierarchy;
    }

    public JsonStatSeriesHierarchy getSeriesHierarchy() {
        return this.seriesHierarchy;
    }

    public JsonStatTime getTime() {
        return this.time;
    }

    private static JsonStatSeriesHierarchy buildForecastingHierarchy(JSONObject jsonStat) {
        String[] idArray = JsonStat.getIdArray(jsonStat);
        int[] sizeArray = JsonStat.getSizeArray(jsonStat);
        String[] timeArray = JsonStat.getTimeArray(jsonStat);
        ArrayList<JsonStatDimension> dims = new ArrayList<JsonStatDimension>();
        for (int i = 0; i < idArray.length; ++i) {
            if (JsonStat.isTimeDimension(idArray, timeArray, i) || sizeArray[i] <= 1) continue;
            dims.add(JsonStat.getDimension(jsonStat, idArray[i], i));
        }
        if (dims.isEmpty()) {
            throw new IllegalDataAccessRequest("Invalid input - all time dimensions");
        }
        return new JsonStatSeriesHierarchy(dims.toArray(new JsonStatDimension[dims.size()]));
    }

    private static boolean isTimeDimension(String[] idArray, String[] timeArray, int i) {
        boolean isTime = false;
        for (int j = 0; j < timeArray.length; ++j) {
            if (!idArray[i].equals(timeArray[j])) continue;
            isTime = true;
            break;
        }
        return isTime;
    }

    private static JsonStatTime buildTime(DataAccessProvider provider, String timeId) {
        int timeIndex = JsonStat.getTimeIndex(provider, timeId);
        String[] categories = null;
        switch (provider.getMetaData().getFieldType(timeIndex)) {
            case CATEGORICAL: {
                categories = (String[])IntStream.range(0, provider.getMetaData().getFieldCategories(timeIndex)).mapToObj(i -> provider.getMetaData().getFieldCategoryLabel(timeIndex, i)).toArray(String[]::new);
                break;
            }
            case NUMERICAL: 
            case DATETIME: {
                categories = (String[])IntStream.range(0, provider.getMetaData().rowCount()).mapToObj(i -> "t" + i).toArray(String[]::new);
                break;
            }
        }
        return new JsonStatTime(new JsonStatDimension[]{new JsonStatDimension(timeId, 0, categories, null)});
    }

    private static int getTimeIndex(DataAccessProvider provider, String timeId) {
        int timeIndex = 0;
        for (int i = 0; i < provider.getMetaData().fieldCount(); ++i) {
            if (!provider.getMetaData().getFieldIdentifier(i).equals(timeId)) continue;
            timeIndex = i;
            break;
        }
        return timeIndex;
    }

    private static JsonStatTime buildTime(JSONObject jsonStat) {
        String[] timeArray = JsonStat.getTimeArray(jsonStat);
        JsonStatDimension[] dims = new JsonStatDimension[timeArray.length];
        for (int i = 0; i < dims.length; ++i) {
            int dimIndex = -1;
            String[] idArray = JsonStat.getIdArray(jsonStat);
            for (int j = 0; j < idArray.length; ++j) {
                if (!timeArray[i].equals(idArray[j])) continue;
                dimIndex = j;
            }
            if (dimIndex == -1) {
                throw new IllegalDataAccessRequest("Invalid input - time id not found");
            }
            dims[i] = JsonStat.getDimension(jsonStat, timeArray[i], dimIndex);
        }
        return new JsonStatTime(dims);
    }

    private static int[] getDataIndices(DataAccessProvider provider, JSONObject hierarchy) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        try {
            Set metrics = hierarchy.getJSONObject(DIMENSION_KEY).keySet();
            JSONArray fieldsArray = hierarchy.getJSONObject(DIMENSION_KEY).getJSONObject((String)metrics.iterator().next()).getJSONObject(CATEGORY_KEY).getJSONArray("index");
            block2: for (Object field : fieldsArray) {
                for (int i = 0; i < provider.getMetaData().fieldCount(); ++i) {
                    if (!provider.getMetaData().getFieldIdentifier(i).equals(field.toString())) continue;
                    indices.add(i);
                    continue block2;
                }
            }
            return indices.stream().mapToInt(v -> v).toArray();
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent metric value", e);
        }
    }

    public JsonStatDataAccessProvider asDataAccessProvider() {
        return new JsonStatDataAccessProvider(this.data, this.time, this.seriesHierarchy);
    }

    private static double[] getValueArray(DataAccessProvider provider, int[] dataIndices) {
        int rows = provider.getMetaData().rowCount();
        double[] values = new double[rows * dataIndices.length];
        DataIterator iter = provider.getDataIterator();
        for (int i = 0; i < rows; ++i) {
            DataRow row = (DataRow)iter.next();
            for (int j = 0; j < dataIndices.length; ++j) {
                values[i * dataIndices.length + j] = row.getValue(dataIndices[j]);
            }
        }
        return values;
    }

    private static double[] getValueArray(JSONObject jsonStat) {
        try {
            JSONArray valueArray = jsonStat.getJSONArray(VALUE_KEY);
            double[] value = new double[valueArray.size()];
            for (int i = 0; i < valueArray.size(); ++i) {
                value[i] = valueArray.getDouble(i);
            }
            return value;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent value array", e);
        }
    }

    private static int[] getSizeArray(JSONObject jsonStat) {
        try {
            JSONArray sizeArray = jsonStat.getJSONArray(SIZE_KEY);
            int[] size = new int[sizeArray.length()];
            for (int i = 0; i < sizeArray.length(); ++i) {
                size[i] = sizeArray.getInt(i);
            }
            return size;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent size array", e);
        }
    }

    private static String[] getIdArray(JSONObject jsonStat) {
        try {
            JSONArray idArray = jsonStat.getJSONArray(ID_KEY);
            String[] id = new String[idArray.length()];
            for (int i = 0; i < idArray.length(); ++i) {
                id[i] = idArray.getString(i);
            }
            return id;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent id array", e);
        }
    }

    private static JsonStatDimension getDimension(JSONObject jsonStat, String dimId, int index) {
        return new JsonStatDimension(dimId, index, JsonStat.getFieldCategories(jsonStat, dimId), JsonStat.getChildMap(jsonStat, dimId));
    }

    private static String[] getFieldCategories(JSONObject jsonStat, String fieldId) {
        try {
            String[] categories;
            JSONObject field = jsonStat.getJSONObject(DIMENSION_KEY).getJSONObject(fieldId);
            JSONObject categoryObject = field.getJSONObject(CATEGORY_KEY);
            if (!categoryObject.containsKey(INDEX_KEY)) {
                return new String[0];
            }
            Object indexObject = categoryObject.get(INDEX_KEY);
            if (indexObject instanceof JSONArray) {
                JSONArray indexArray = (JSONArray)indexObject;
                categories = new String[indexArray.length()];
                for (int i = 0; i < indexArray.length(); ++i) {
                    categories[i] = indexArray.getString(i);
                }
            } else {
                JSONObject indexArray = (JSONObject)indexObject;
                categories = new String[indexArray.entrySet().size()];
                Iterator keyIter = indexArray.keys();
                while (keyIter.hasNext()) {
                    String key;
                    categories[indexArray.getInt((String)key)] = key = (String)keyIter.next();
                }
            }
            return categories;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent category index", e);
        }
    }

    private static Map<String, List<String>> getChildMap(JSONObject jsonStat, String fieldId) {
        HashMap<String, List<String>> children = new HashMap<String, List<String>>();
        try {
            JSONObject child = jsonStat.getJSONObject(DIMENSION_KEY).getJSONObject(fieldId).getJSONObject(CATEGORY_KEY).optJSONObject("child");
            if (child == null) {
                return new HashMap<String, List<String>>();
            }
            for (Object key : child.keySet()) {
                JSONArray childrenJson = child.getJSONArray((String)key);
                ArrayList<String> childrenArray = new ArrayList<String>();
                for (int i = 0; i < childrenJson.length(); ++i) {
                    String label = childrenJson.getString(i);
                    childrenArray.add(label);
                }
                children.put((String)key, childrenArray);
            }
            return children;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent category child", e);
        }
    }

    private static String[] getTimeArray(JSONObject jsonStat) {
        try {
            JSONArray timeArray = jsonStat.getJSONObject(ROLE_KEY).getJSONArray(TIME_KEY);
            String[] strTimeArray = new String[timeArray.length()];
            for (int i = 0; i < timeArray.length(); ++i) {
                strTimeArray[i] = timeArray.getString(i);
            }
            return strTimeArray;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Attempting to access non-existent time array", e);
        }
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put(VERSION_KEY, (Object)VERSION);
            JSONArray value = new JSONArray();
            for (int i = 0; i < this.data.length; ++i) {
                value.add((Object)this.data[i]);
            }
            json.put(VALUE_KEY, (Collection)value);
            JSONObject dimension = new JSONObject();
            JSONArray ids = new JSONArray();
            JSONArray sizes = new JSONArray();
            JSONArray times = new JSONArray();
            JSONArray metrics = new JSONArray();
            this.processDims(this.time.getDimensions(), dimension, ids, sizes, times);
            this.processDims(this.seriesHierarchy.getDims(), dimension, ids, sizes, metrics);
            json.put(ID_KEY, (Collection)ids);
            json.put(SIZE_KEY, (Collection)sizes);
            JSONObject role = new JSONObject();
            role.put(TIME_KEY, (Collection)times);
            role.put(METRIC_KEY, (Collection)metrics);
            json.put(ROLE_KEY, (Map)role);
            json.put(DIMENSION_KEY, (Map)dimension);
            return json;
        }
        catch (JSONException e) {
            throw new IllegalDataAccessRequest("Error generating JSON for a JsonStat object", e);
        }
    }

    private void processDims(JsonStatDimension[] dims, JSONObject dimension, JSONArray ids, JSONArray sizes, JSONArray opts) throws JSONException {
        for (int i = 0; i < dims.length; ++i) {
            ids.add((Object)dims[i].getId());
            sizes.add((Object)dims[i].getCategories().length);
            opts.add((Object)dims[i].getId());
            Map<String, List<String>> childMap = dims[i].getChildMap();
            JSONObject dimValue = new JSONObject();
            JSONObject category = new JSONObject();
            JSONArray index = new JSONArray();
            JSONObject children = new JSONObject();
            for (int j = 0; j < dims[i].getCategories().length; ++j) {
                index.add((Object)dims[i].getCategories()[j]);
            }
            category.put(INDEX_KEY, (Object)index);
            if (dims[i].getChildMap() != null) {
                Object[] metrics = dims[i].getChildMap().keySet().toArray();
                for (int j = 0; j < metrics.length; ++j) {
                    children.put((String)metrics[j], (Collection)new JSONArray((Collection)childMap.get(metrics[j])));
                }
                category.put("child", (Map)children);
            }
            dimValue.put(CATEGORY_KEY, (Map)category);
            dimension.put(dims[i].getId(), (Map)dimValue);
        }
    }
}

