/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.ibm.bi.predict.dataaccess.types.FieldType;
import java.nio.charset.Charset;

class JsonStatField {
    private final int index;
    private final String id;
    private final FieldType type;
    private final byte[][] categories;
    private static final Charset utf8 = Charset.forName("utf-8");

    JsonStatField(int index, String id, FieldType type, String[] categories) {
        this.index = index;
        this.id = id;
        this.type = type;
        if (categories == null) {
            this.categories = null;
        } else {
            this.categories = new byte[categories.length][];
            for (int i = 0; i < categories.length; ++i) {
                this.categories[i] = categories[i].getBytes(utf8);
            }
        }
    }

    String getId() {
        return this.id;
    }

    int getIndex() {
        return this.index;
    }

    FieldType getType() {
        return this.type;
    }

    int getCategories() {
        return this.categories == null ? -1 : this.categories.length;
    }

    String getCategoryValue(int categoryIndex) {
        return new String(this.categories[categoryIndex], utf8);
    }
}

