/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatField;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsonStatMetaData
implements MetaData {
    private int rowCount;
    private List<JsonStatField> fields;

    public JsonStatMetaData(int rowCount, List<JsonStatField> fields) {
        this.rowCount = rowCount;
        this.fields = fields;
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int fieldCount() {
        return this.fields.size();
    }

    @Override
    public String getFieldIdentifier(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getId();
    }

    @Override
    public FieldType getFieldType(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getType();
    }

    @Override
    public List<Tuple<String, Double>> getConcepts(int columnIndex) {
        if (columnIndex == 0) {
            return Arrays.asList(new Tuple((Object)"http://www.ibm.com/ontologies/waca/domain/common#Season", (Object)1.0));
        }
        return Collections.emptyList();
    }

    @Override
    public int getFieldCategories(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.fields.size()) {
            throw new IllegalDataAccessRequest();
        }
        return this.fields.get(columnIndex).getCategories();
    }

    @Override
    public StatisticStatus getStatisticStatus(String statisticName, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIndex, int categoryIndex) {
        return Collections.emptyList();
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        this.checkColumnIndex(columnIndex);
        JsonStatField field = this.fields.get(columnIndex);
        if (field.getType() != FieldType.CATEGORICAL && field.getType() != FieldType.DATETIME) {
            throw new IllegalDataAccessRequest("Requested category label when field was not categorical: " + field.getId());
        }
        if (categoryIndex < 0 || categoryIndex >= field.getCategories()) {
            throw new IllegalDataAccessRequest("Illegal category index requested: " + categoryIndex);
        }
        return field.getCategoryValue(categoryIndex);
    }

    @Override
    public AggregationType getFieldAggregation(int columnIndex) {
        return AggregationType.NONE;
    }

    @Override
    public String getFieldDisplayLabel(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        return String.format("%s_label", this.fields.get(columnIndex).getId());
    }

    private void checkColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex > this.fields.size()) {
            throw new IllegalDataAccessRequest("Illegal column index requested: " + columnIndex);
        }
    }
}

