/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.jsonstat;

import com.ibm.bi.predict.dataaccess.jsonstat.JsonStatDimension;

public class JsonStatTime {
    private final JsonStatDimension[] dims;
    private final int[] fieldIncrement;

    public JsonStatTime(JsonStatDimension[] dims) {
        this.dims = dims;
        this.fieldIncrement = new int[dims.length];
        for (int fieldIndex = 0; fieldIndex < dims.length; ++fieldIndex) {
            this.fieldIncrement[fieldIndex] = 1;
            for (int j = fieldIndex + 1; j < dims.length; ++j) {
                int n = fieldIndex;
                this.fieldIncrement[n] = this.fieldIncrement[n] * dims[j].getCategories().length;
            }
        }
    }

    public JsonStatDimension[] getDimensions() {
        return this.dims;
    }

    public JsonStatDimension getDimension(int timeIndex) {
        return this.dims[timeIndex];
    }

    public int getValue(int[] indices) {
        int value = 0;
        for (int i = 0; i < this.dims.length; ++i) {
            value += indices[i] * this.fieldIncrement[i];
        }
        return value;
    }

    public int[] getIndices(int value) {
        int[] indices = new int[this.dims.length];
        for (int i = 0; i < this.dims.length; ++i) {
            indices[i] = value / this.fieldIncrement[i];
            value %= this.fieldIncrement[i];
        }
        return indices;
    }
}

