/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.wrappers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.wrappers.DataSourceWrappedAsDataRow;
import com.ibm.bi.predict.source.ColumnRelationship;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.builder.SourceFromEndorResultSet;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONObject;

public class DataSourceWrappedAsDataIterator
implements DataIterator {
    private DataSource source;
    private Iterator<Row> sourceIterator;
    private final Map<Integer, BiMap<Double, List<Double>>> groupMappings;

    public static DataIterator parse(JSONObject dataset, Map<String, RoleType> rolesMap, Map<String, List<Tuple<String, Double>>> conceptsMap) {
        DataSource source = SourceFromEndorResultSet.parse(dataset, rolesMap, conceptsMap);
        return new DataSourceWrappedAsDataIterator(source);
    }

    public DataSourceWrappedAsDataIterator(DataSource source) {
        this.source = source;
        this.sourceIterator = source.rowIterator();
        this.groupMappings = this.createGroupMappings();
    }

    @Override
    public boolean hasNext() {
        return this.sourceIterator.hasNext();
    }

    @Override
    public DataRow next() {
        Row r = this.sourceIterator.next();
        Map<Tuple<String, Integer>, Integer> statsMap = DataSourceWrappedAsDataIterator.buildStatsMap(this.source);
        return new DataSourceWrappedAsDataRow(r, this.source, statsMap, this.groupMappings);
    }

    @Override
    public void reset() {
        this.sourceIterator = this.source.rowIterator();
    }

    private Map<Integer, BiMap<Double, List<Double>>> createGroupMappings() {
        Map<Integer, BiMap<Double, List<Double>>> groupMap = new HashMap<Integer, BiMap<Double, List<Double>>>();
        int groups = this.source.groups().size();
        int[] columnsPerGroup = this.getColumnsPerGroup(groups);
        for (int i = 0; i < groups; ++i) {
            groupMap.put(i, (BiMap<Double, List<Double>>)HashBiMap.create());
        }
        while (this.sourceIterator.hasNext()) {
            Row row = this.sourceIterator.next();
            groupMap = this.addRowToMap(row, columnsPerGroup, groupMap);
        }
        this.reset();
        return groupMap;
    }

    private Map<Integer, BiMap<Double, List<Double>>> addRowToMap(Row row, int[] columnsPerGroup, Map<Integer, BiMap<Double, List<Double>>> groupMap) {
        int rowIndex = 0;
        for (int i = 0; i < columnsPerGroup.length; ++i) {
            ArrayList<Double> listValues = new ArrayList<Double>();
            if (columnsPerGroup[i] == 1) {
                listValues.add(row.valueAt(rowIndex));
                groupMap.get(i).put((Object)row.valueAt(rowIndex), listValues);
            } else {
                for (int j = 0; j < columnsPerGroup[i]; ++j) {
                    listValues.add(row.valueAt(rowIndex + j));
                }
                int new_index = groupMap.get(i).size();
                if (!groupMap.get(i).containsKey((Object)new_index) && !groupMap.get(i).containsValue(listValues)) {
                    groupMap.get(i).put((Object)new_index, listValues);
                }
            }
            rowIndex += columnsPerGroup[i];
        }
        return groupMap;
    }

    private int[] getColumnsPerGroup(int groups) {
        int[] columnsPerGroup = new int[groups];
        IntStream.range(0, groups).forEach(i -> {
            columnsPerGroup[i] = this.source.groups().get(i).columns().size();
        });
        return columnsPerGroup;
    }

    private static Map<Tuple<String, Integer>, Integer> buildStatsMap(DataSource source) {
        HashMap<Tuple<String, Integer>, Integer> result = new HashMap<Tuple<String, Integer>, Integer>();
        for (ColumnRelationship r : source.meta().relationships()) {
            if (!r.relationship().startsWith("statistic:")) continue;
            result.put((Tuple<String, Integer>)Tuple.of((Object)r.relationship().substring("statistic:".length()), (Object)r.A().index()), r.B().index());
        }
        return result;
    }
}

