/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.wrappers;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.json.JsonDecorator;
import com.ibm.bi.predict.dataaccess.wrappers.DataSourceWrappedAsDataIterator;
import com.ibm.bi.predict.dataaccess.wrappers.SourceMetaDataAsMetaData;
import com.ibm.bi.predict.source.DataSource;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.json.JSONObject;

public class DataSourceWrappedDataAccessProvider
implements DataAccessProvider {
    private final DataSource dataSource;
    private final MetaData metadata;
    private final Decorator decorator;

    public DataSourceWrappedDataAccessProvider(DataSource dataSource, JSONObject inputData) {
        this(dataSource, inputData, Collections.emptyMap());
    }

    public DataSourceWrappedDataAccessProvider(DataSource dataSource, JSONObject inputData, Map<String, String> fieldIdToDataType) {
        this.dataSource = dataSource;
        this.metadata = new SourceMetaDataAsMetaData(dataSource, fieldIdToDataType);
        this.decorator = new JsonDecorator(inputData);
    }

    @Override
    public MetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public DataIterator getDataIterator() {
        return new DataSourceWrappedAsDataIterator(this.dataSource);
    }

    @Override
    public Decorator getDecorator() {
        return this.decorator;
    }
}

