/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.wrappers;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.ColumnRelationship;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.LabeledIdentifier;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.SourceProperty;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SourceMetaDataAsMetaData
implements MetaData {
    private static final Logger logger = PredictLoggerFactory.getLogger(SourceMetaDataAsMetaData.class);
    private final DataSource dataSource;
    private final SourceMetaData metadata;
    private final Map<Tuple<String, Integer>, Integer> statsMap;
    private final Map<String, String> fieldIdToDataType;
    private final Map<Integer, FieldType> fieldTypesByIndex = new HashMap<Integer, FieldType>();
    private final Map<Integer, Integer> categoryCountsByIndex = new HashMap<Integer, Integer>();
    private final Map<Integer, List<ColumnMetaData>> columnsByIndex = new HashMap<Integer, List<ColumnMetaData>>();
    private final Map<Tuple<Integer, Integer>, String> categoryLabelByIndex = new HashMap<Tuple<Integer, Integer>, String>();
    private Map<String, List<Tuple<String, Double>>> concepts;

    public SourceMetaDataAsMetaData(DataSource source) {
        this.dataSource = source;
        this.metadata = source.meta();
        this.statsMap = SourceMetaDataAsMetaData.buildStatsMap(source);
        this.fieldIdToDataType = Collections.emptyMap();
    }

    public SourceMetaDataAsMetaData(DataSource source, Map<String, String> fieldIdToDataType) {
        this.dataSource = source;
        this.metadata = source.meta();
        this.statsMap = SourceMetaDataAsMetaData.buildStatsMap(source);
        this.fieldIdToDataType = fieldIdToDataType;
    }

    @Override
    public int rowCount() {
        return this.metadata.rowCount();
    }

    @Override
    public int fieldCount() {
        return this.dataSource.groups().size();
    }

    @Override
    public String getFieldIdentifier(int columnIndex) {
        return this.columnGroup(columnIndex).id().toString();
    }

    @Override
    public String getFieldCategoryIdentifier(int columnIndex, int categoryIndex) {
        if (this.itemsInField(columnIndex) > 1) {
            logger.warn("Trying to get single category identifier of multiple fields");
        }
        ColumnMetaData firstColumn = this.column(this.columnGroup(columnIndex).columns().get(0));
        return this.columnCategory(firstColumn, categoryIndex).id().toString();
    }

    @Override
    public String getFieldDisplayLabel(int columnIndex) {
        if (this.itemsInField(columnIndex) > 1) {
            logger.warn("Trying to get single label of multiple fields");
        }
        return this.columnGroup(columnIndex).columns().stream().map(LabeledIdentifier::label).collect(Collectors.joining(" - "));
    }

    @Override
    public String getFieldCategoryLabel(int columnIndex, int categoryIndex) {
        return this.categoryLabelByIndex.computeIfAbsent((Tuple<Integer, Integer>)Tuple.of((Object)columnIndex, (Object)categoryIndex), c -> String.join((CharSequence)"|", this.getFieldCategoryLabels(columnIndex, categoryIndex)));
    }

    @Override
    public FieldType getFieldType(int columnIndex) {
        String datatype = this.fieldIdToDataType.get(this.getFieldIdentifier(columnIndex));
        if (datatype != null) {
            return FieldType.fromString((String)datatype);
        }
        return this.fieldTypesByIndex.computeIfAbsent(columnIndex, c -> this.columns(columnIndex).get(0).type());
    }

    @Override
    public int getFieldCategories(int columnIndex) {
        FieldType fieldType = this.getFieldType(columnIndex);
        if (fieldType != FieldType.CATEGORICAL && fieldType != FieldType.DATETIME) {
            throw new IllegalDataAccessRequest("Attempting to access categories on non-categorical field");
        }
        return this.categoryCountsByIndex.computeIfAbsent(columnIndex, c -> {
            int categoryCount = this.columns(columnIndex).stream().map(ColumnMetaData::categoryCount).reduce(1, (acc, v) -> acc * v);
            return Math.min(this.rowCount(), categoryCount);
        });
    }

    @Override
    public StatisticStatus getStatisticStatus(String statisticName, int columnIndex) {
        for (ColumnIdentifier id : this.columnGroup(columnIndex).columns()) {
            if (this.statsMap.containsKey(Tuple.of((Object)statisticName, (Object)id.index()))) continue;
            return StatisticStatus.UNAVAILABLE;
        }
        return StatisticStatus.AVAILABLE;
    }

    @Override
    public List<Tuple<String, Double>> getConcepts(int columnIndex) {
        ColumnIdentifier firstColumn = this.columnGroup(columnIndex).columns().get(0);
        return this.conceptsMapToList(this.column(firstColumn).concepts());
    }

    @Override
    public void setConcepts(Map<String, List<Tuple<String, Double>>> concepts) {
        this.concepts = concepts;
    }

    @Override
    public Map<String, List<Tuple<String, Double>>> getConceptsMap() {
        if (this.concepts == null) {
            this.concepts = this.buildConceptsMap();
        }
        return this.concepts;
    }

    @Override
    public AggregationType getFieldAggregation(int columnIndex) {
        List<ColumnIdentifier> columnIdentifiers = this.columnGroup(columnIndex).columns();
        return this.column(columnIdentifiers.get(0)).aggregation();
    }

    @Override
    public boolean isClippedData() {
        return this.metadata.hasCharacteristic(SourceProperty.clipped);
    }

    @Override
    public List<String> getFieldIdentifiers(int columnIndex) {
        return this.columnGroup(columnIndex).columns().stream().map(LabeledIdentifier::id).map(Objects::toString).collect(Collectors.toList());
    }

    @Override
    public List<String> getFieldDisplayLabels(int columnIndex) {
        return this.columnGroup(columnIndex).columns().stream().map(LabeledIdentifier::label).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getUniqueIdentifiersMap(int columnIndex) {
        return this.columns(columnIndex).stream().collect(Collectors.toMap(cmd -> cmd.identifier().id().toString(), cmd -> cmd.getMetaData("endor_data_id").toString()));
    }

    @Override
    public List<String> getFieldCategoryLabels(int columnIndex, int categoryIndex) {
        return this.columnCategories(columnIndex, categoryIndex).stream().map(LabeledIdentifier::label).collect(Collectors.toList());
    }

    @Override
    public List<String> getFieldCategoryIdentifiers(int columnIndex, int categoryIndex) {
        return this.columnCategories(columnIndex, categoryIndex).stream().map(LabeledIdentifier::id).map(Objects::toString).collect(Collectors.toList());
    }

    @Override
    public List<AggregationType> getFieldCategoryAggregations(int columnIndex, int categoryIndex) {
        return this.columnCategories(columnIndex, categoryIndex).stream().map(cat -> {
            if (cat.containsMetaData("aggregate")) {
                return cat.getMetaData("aggregate").toString();
            }
            return null;
        }).map(AggregationType::fromString).collect(Collectors.toList());
    }

    @Override
    public int itemsInField(int columnIndex) {
        return this.columnGroup(columnIndex).columns().size();
    }

    private List<ColumnMetaData> columns(int columnIndex) {
        return this.columnsByIndex.computeIfAbsent(columnIndex, c -> this.columnGroup(columnIndex).columns().stream().map(this::column).collect(Collectors.toList()));
    }

    private List<Category> columnCategories(int columnIndex, int categoryIndex) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (int i = 0; i < this.itemsInField(columnIndex); ++i) {
            ColumnMetaData col = this.column(this.columnGroup(columnIndex).columns().get(i));
            categories.add(this.columnCategory(col, categoryIndex));
        }
        return categories;
    }

    private Category columnCategory(ColumnMetaData col, int categoryIndex) {
        if (col.containsMetaData("category_mappings")) {
            int[] mapping = (int[])col.getMetaData("category_mappings");
            int cat = mapping[categoryIndex];
            return col.categories().get(cat);
        }
        return col.categories().get(categoryIndex);
    }

    private ColumnMetaData column(ColumnIdentifier id) {
        int columnIndex = id.index();
        if (columnIndex < 0 || columnIndex >= this.metadata.columnMetaData().size()) {
            throw new IllegalDataAccessRequest("Invalid column index: " + columnIndex);
        }
        return this.metadata.columnMetaData().get(columnIndex);
    }

    private ColumnGroup columnGroup(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.fieldCount()) {
            throw new IllegalDataAccessRequest("Invalid column index: " + columnIndex);
        }
        return this.dataSource.groups().get(columnIndex);
    }

    private List<Tuple<String, Double>> conceptsMapToList(Map<String, Double> map) {
        return map.entrySet().stream().map(e -> Tuple.of(e.getKey(), e.getValue())).collect(Collectors.toList());
    }

    private static Map<Tuple<String, Integer>, Integer> buildStatsMap(DataSource source) {
        HashMap<Tuple<String, Integer>, Integer> result = new HashMap<Tuple<String, Integer>, Integer>();
        for (ColumnRelationship r : source.meta().relationships()) {
            if (!r.relationship().startsWith("statistic:")) continue;
            result.put((Tuple<String, Integer>)Tuple.of((Object)r.relationship().substring("statistic:".length()), (Object)r.A().index()), r.B().index());
        }
        return result;
    }

    private Map<String, List<Tuple<String, Double>>> buildConceptsMap() {
        HashMap<String, List<Tuple<String, Double>>> conceptsMap = new HashMap<String, List<Tuple<String, Double>>>();
        for (ColumnGroup group : this.dataSource.groups()) {
            for (ColumnIdentifier id : group.columns()) {
                ColumnMetaData colMeta = this.column(id);
                String mapKey = colMeta.getMetaData("endor_data_id").toString();
                List l = colMeta.concepts().entrySet().stream().map(e -> Tuple.of(e.getKey(), e.getValue())).collect(Collectors.toList());
                if (l.isEmpty()) continue;
                conceptsMap.put(mapKey, l);
            }
        }
        return conceptsMap;
    }
}

