/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.source.LabeledIdentifier;
import com.ibm.bi.predict.source.MetaDataAware;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Category
extends LabeledIdentifier
implements MetaDataAware {
    private static final char CONTAINS_ELEMENT_SYMBOL = '\u220b';
    private final List<Category> children;
    private Map<String, Object> metadata;

    public Category(Object id, String label, List<Category> children) {
        super(id, label);
        this.children = Objects.requireNonNull(children, "Pass empty collection, not null, if no children");
        this.metadata = Collections.emptyMap();
    }

    public Category(Object id, String label) {
        this(id, label, Collections.emptyList());
    }

    public List<Category> children() {
        return this.children;
    }

    @Override
    public String toString() {
        if (this.children.isEmpty()) {
            return super.toString();
        }
        return super.toString() + '\u220b' + this.children;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category)obj;
        return super.equals(obj) && Objects.equals(this.children, other.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }

    @Override
    public MetaDataAware putMetaData(String key, Object value) {
        if (this.metadata.isEmpty()) {
            this.metadata = new HashMap<String, Object>();
        }
        if (value == null) {
            this.metadata.remove(key);
        } else {
            this.metadata.put(key, value);
        }
        return this;
    }

    @Override
    public boolean containsMetaData(String key) {
        return this.metadata.containsKey(key);
    }

    @Override
    public Object getMetaData(String key) {
        return this.metadata.get(key);
    }
}

