/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.LabeledIdentifier;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ColumnGroup
extends LabeledIdentifier {
    private final Set<Enum> properties;
    private final List<ColumnIdentifier> columns;

    public static int[] columnsIndices(List<ColumnGroup> groups, Set<Enum> types) {
        return groups.stream().filter(g -> g.hasAnyProperty(types)).flatMap(g -> g.columns().stream()).map(c -> c.index()).sorted().mapToInt(i -> i).toArray();
    }

    public static int[] columnsIndices(List<ColumnGroup> groups, Enum ... types) {
        return ColumnGroup.columnsIndices(groups, Sets.newHashSet((Object[])types));
    }

    public ColumnGroup(Object id, String label, Set<Enum> properties, List<ColumnIdentifier> columns) {
        super(id, label);
        this.properties = Objects.requireNonNull(properties, "Properties must be defined");
        this.columns = Objects.requireNonNull(columns, "Columns must be defined");
    }

    public List<ColumnIdentifier> columns() {
        return this.columns;
    }

    public Set<Enum> properties() {
        return this.properties;
    }

    public boolean hasProperty(Enum e) {
        return this.properties.contains(e);
    }

    public boolean hasAnyProperty(Set<Enum> props) {
        for (Enum p : props) {
            if (!this.hasProperty(p)) continue;
            return true;
        }
        return false;
    }
}

