/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.source.Category;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataColumnInfo {
    private List<com.ibm.bi.predict.data.Category> categories;
    private double[] data;

    public DataColumnInfo(int rowCount, List<Category> categories) {
        this.categories = DataColumnInfo.makeColumnCategories(categories);
        this.data = new double[rowCount];
    }

    public void add(double value, int rowIndex) {
        this.data[rowIndex] = value;
    }

    public DataColumn build(DataColumn.ColumnMeta columnMeta, int columnIndex) {
        return new DataColumn(columnMeta, this.categories, this.data, columnIndex);
    }

    public DataColumn build(List<DataColumn> childColumns, int[] timeIndices) {
        DataColumn.ColumnMeta columnMeta = DataColumnInfo.makeParentColumnMeta(childColumns, timeIndices);
        return new DataColumn(columnMeta, this.categories, this.data, -1);
    }

    private static List<com.ibm.bi.predict.data.Category> makeColumnCategories(List<Category> categories) {
        if (categories == null) {
            return Collections.emptyList();
        }
        ArrayList<com.ibm.bi.predict.data.Category> columnCategories = new ArrayList<com.ibm.bi.predict.data.Category>();
        for (Category category : categories) {
            columnCategories.add(com.ibm.bi.predict.data.Category.forString(category.label(), columnCategories.size()));
        }
        return columnCategories;
    }

    private static DataColumn.ColumnMeta makeParentColumnMeta(List<DataColumn> dataColumns, int[] timeIndices) {
        StringBuilder parentIdBuilder = new StringBuilder();
        parentIdBuilder.append(dataColumns.get(timeIndices[0]).getMeta().getId());
        StringBuilder parentLabelBuilder = new StringBuilder();
        parentLabelBuilder.append(dataColumns.get(timeIndices[0]).getMeta().getLabel());
        for (int i = 1; i < timeIndices.length; ++i) {
            DataColumn.ColumnMeta meta = dataColumns.get(timeIndices[i]).getMeta();
            parentIdBuilder.append("|").append(meta.getId());
            parentLabelBuilder.append("|").append(meta.getLabel());
        }
        return new DataColumn.ColumnMeta(parentIdBuilder.toString(), parentLabelBuilder.toString(), FieldType.DATETIME, AggregationType.NONE, Collections.emptyList());
    }
}

