/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DataSource {
    private final SourceMetaData meta;
    private final Collection<Row> rows;
    private final List<ColumnGroup> groups;

    public DataSource(SourceMetaData meta, Collection<Row> rows) {
        this(meta, rows, Collections.emptyList());
    }

    public DataSource(SourceMetaData meta, Collection<Row> rows, List<ColumnGroup> groups) {
        this.meta = meta;
        this.rows = rows;
        this.groups = groups;
    }

    public List<ColumnGroup> groups() {
        return this.groups;
    }

    public SourceMetaData meta() {
        return this.meta;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public Iterator<Row> rowIterator() {
        return this.rows.iterator();
    }

    public Collection<Row> rows() {
        return this.rows;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return new EqualsBuilder().append((Object)this.meta, (Object)other.meta).append(this.rows, other.rows).append(this.groups, other.groups).isEquals();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.meta, this.rows, this.groups);
    }
}

