/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source;

import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.ColumnRelationship;
import com.ibm.bi.predict.source.LabeledIdentifier;
import com.ibm.bi.predict.source.SourceProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class SourceMetaData {
    private final List<ColumnMetaData> columnMetaData;
    private final Set<SourceProperty> properties;
    private final Collection<ColumnRelationship> relationships;

    public SourceMetaData(List<ColumnMetaData> columnMetaData) {
        this(columnMetaData, Collections.emptySet(), Collections.emptyList());
    }

    public SourceMetaData(List<ColumnMetaData> columnMetaData, Set<SourceProperty> properties) {
        this(columnMetaData, properties, Collections.emptyList());
    }

    public SourceMetaData(List<ColumnMetaData> columnMetaData, Set<SourceProperty> properties, Collection<ColumnRelationship> relationships) {
        this.columnMetaData = columnMetaData;
        this.properties = properties;
        this.relationships = relationships;
        this.validateParametersAreNonNull();
        this.validateColumnsHaveUniqueIDs();
        this.validateColumnsSpanAllIndices();
        this.validateRelationshipsHaveKnownColumns();
    }

    public Stream<ColumnIdentifier> columnsThatRelateToOthers(Predicate<String> matchingRelationship) {
        return this.relationships.stream().filter(r -> matchingRelationship.test(r.relationship())).map(ColumnRelationship::A).distinct();
    }

    public Stream<ColumnIdentifier> columnsThatARelationTargets(Predicate<String> matchingRelationship) {
        return this.relationships.stream().filter(r -> matchingRelationship.test(r.relationship())).map(ColumnRelationship::B).distinct();
    }

    public Stream<ColumnIdentifier> columnsWithoutRelationships(Predicate<String> matchingRelationship) {
        Set withRelationships = Stream.concat(this.columnsThatRelateToOthers(matchingRelationship), this.columnsThatARelationTargets(matchingRelationship)).collect(Collectors.toSet());
        return this.columnMetaData.stream().map(ColumnMetaData::identifier).filter(id -> !withRelationships.contains(id));
    }

    public Set<SourceProperty> properties() {
        return this.properties;
    }

    public List<ColumnMetaData> columnMetaData() {
        return this.columnMetaData;
    }

    public int columnCount() {
        return this.columnMetaData.size();
    }

    public Collection<ColumnRelationship> relationships() {
        return this.relationships;
    }

    public boolean hasCharacteristic(SourceProperty c) {
        return this.properties.contains((Object)c);
    }

    public int rowCount() {
        return this.columnMetaData.isEmpty() ? 0 : this.columnMetaData.get(0).rowCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SourceMetaData{");
        sb.append("#cols=").append(this.columnCount());
        if (!this.properties.isEmpty()) {
            sb.append(", properties=").append(this.properties);
        }
        if (!this.relationships.isEmpty()) {
            sb.append(", #relations=").append(this.relationships.size());
            sb.append('}');
        }
        return sb.toString();
    }

    private void validateColumnsSpanAllIndices() {
        if (this.columnMetaData.isEmpty()) {
            return;
        }
        int[] indices = this.columnMetaData.stream().mapToInt(m -> m.identifier().index()).distinct().sorted().toArray();
        if (indices.length != this.columnMetaData.size()) {
            throw new IllegalStateException("All column indices must be unique");
        }
        int last = indices.length - 1;
        if (indices[0] != 0 || indices[last] != last) {
            throw new IllegalStateException("Column indices must start at zero and have no gaps");
        }
    }

    private void validateRelationshipsHaveKnownColumns() {
        Set columns = this.columnMetaData.stream().map(ColumnMetaData::identifier).collect(Collectors.toSet());
        boolean ok = this.relationships.stream().allMatch(r -> columns.contains(r.A()) && columns.contains(r.B()));
        if (!ok) {
            throw new IllegalStateException("Relationships refer to columns not present in the source");
        }
    }

    private void validateColumnsHaveUniqueIDs() {
        long nDistinct = this.columnMetaData.stream().map(ColumnMetaData::identifier).map(LabeledIdentifier::id).distinct().count();
        if (nDistinct != (long)this.columnMetaData.size()) {
            throw new IllegalStateException("Identifiers for columns must all be unique");
        }
    }

    private void validateParametersAreNonNull() {
        Objects.requireNonNull(this.properties, "Properties must not be null");
        Objects.requireNonNull(this.relationships, "Relationships must not be null");
        Objects.requireNonNull(this.columnMetaData, "Column meta data must not be null");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceMetaData)) {
            return false;
        }
        SourceMetaData other = (SourceMetaData)obj;
        return new EqualsBuilder().append(this.columnMetaData, other.columnMetaData).append(this.properties, other.properties).append(this.relationships, other.relationships).isEquals();
    }

    public int hashCode() {
        return Objects.hash(this.columnMetaData, this.properties, this.relationships);
    }
}

