/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ibm.bi.predict.dataaccess.exception.IllegalDataAccessRequest;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.builder.JsonStatValidator;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class JsonStatToDataSource {
    private static final String VALUES_COLUMN_ID = "value";
    private final JSONObject json;

    public JsonStatToDataSource(JSONObject json) {
        this.json = json;
    }

    public DataSource parse() {
        JsonStatValidator.make(this.json).validate();
        List<ColumnMetaData> columnMeta = this.getColumns();
        return new DataSource(this.getSourceMetaData(columnMeta), this.getRows(), this.getColumnGroups(columnMeta));
    }

    private List<ColumnMetaData> getColumns() {
        List<String> ids = JsonHelpers.getStringList(this.json, "id");
        List<ColumnMetaData> columnMeta = IntStream.range(0, ids.size()).mapToObj(i -> this.columnWithIdAndIndex((String)ids.get(i), i)).collect(Collectors.toList());
        columnMeta.add(new ColumnMetaData(ColumnIdentifier.make(VALUES_COLUMN_ID, VALUES_COLUMN_ID, columnMeta.size()), this.rowCount(), FieldType.NUMERICAL, AggregationType.NONE, null, ColumnFormat.formatForString(), Collections.emptyMap()));
        return columnMeta;
    }

    private SourceMetaData getSourceMetaData(List<ColumnMetaData> columnMeta) {
        return new SourceMetaData(columnMeta);
    }

    private Collection<Row> getRows() {
        List<Integer> sizes = JsonHelpers.getIntList(this.json, "size");
        final List<Tuple<Integer, Double>> ordinalValueTuples = JsonHelpers.getKeyValueTuples(this.json, VALUES_COLUMN_ID);
        final List<String> ids = JsonHelpers.getStringList(this.json, "id");
        final Map<String, List<Category>> categoriesById = this.categoriesById();
        return IntStream.range(0, ordinalValueTuples.size()).mapToObj(i -> {
            final int[] indices = this.indexToIndices((Integer)((Tuple)ordinalValueTuples.get((int)i))._1, sizes);
            return new Row(){

                @Override
                public double valueAt(int index) {
                    if (index >= 0 && index < indices.length) {
                        return indices[index];
                    }
                    if (index == indices.length) {
                        return (Double)((Tuple)ordinalValueTuples.get((int)i))._2;
                    }
                    throw new IllegalArgumentException("Invalid index. Index is out of bounds - index=" + index);
                }

                @Override
                public Category categoryAt(int index) {
                    if (index < 0 || index >= indices.length) {
                        throw new IllegalArgumentException("Invalid index. Index is out of bounds - index=" + index);
                    }
                    int catIdx = indices[index];
                    List categories = (List)categoriesById.get(ids.get(index));
                    if (categories != null) {
                        return (Category)categories.get(catIdx);
                    }
                    throw new IllegalStateException("Cannot access categories of field at position " + index);
                }
            };
        }).collect(Collectors.toList());
    }

    private List<ColumnGroup> getColumnGroups(List<ColumnMetaData> columnMeta) {
        Map columnsById = columnMeta.stream().collect(Collectors.toMap(col -> (String)col.identifier().id(), Function.identity()));
        ImmutableMap groupsByRole = ImmutableMap.of((Object)"time", (Object)Lists.newArrayList(), (Object)"other", (Object)Lists.newArrayList(), (Object)"metric", (Object)Lists.newArrayList(), (Object)VALUES_COLUMN_ID, (Object)Lists.newArrayList());
        JSONArray ids = JsonHelpers.getArray(this.json, "id");
        for (String id : ids) {
            String role = this.definedRoleOfDimension(id).orElse("other");
            ColumnIdentifier column = ((ColumnMetaData)columnsById.get(id)).identifier();
            if (groupsByRole.containsKey(role)) {
                ((List)groupsByRole.get(role)).add(column);
                continue;
            }
            ((List)groupsByRole.get("other")).add(column);
        }
        ((List)groupsByRole.get(VALUES_COLUMN_ID)).add(((ColumnMetaData)columnsById.get(VALUES_COLUMN_ID)).identifier());
        return groupsByRole.entrySet().stream().map(e -> new ColumnGroup(e.getKey(), (String)e.getKey(), Collections.singleton(ColumnGroupType.fromString((String)e.getKey())), (List)e.getValue())).collect(Collectors.toList());
    }

    private Optional<String> definedRoleOfDimension(String id) {
        JSONObject roles = JsonHelpers.getObject(this.json, "role");
        Iterator iter = roles.keys();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            Set<String> idsByRole = JsonHelpers.getStringSet(roles, role);
            if (!idsByRole.contains(id)) continue;
            return Optional.of(role);
        }
        return Optional.empty();
    }

    private ColumnMetaData columnWithIdAndIndex(String id, int index) {
        JSONObject dimension = this.dimensionById(id);
        String label = JsonHelpers.optString(dimension, "label").orElse(id);
        Map<String, Double> concepts = this.roleContains("time", id) ? Collections.singletonMap("http://www.ibm.com/ontologies/waca/domain/common#Period", 1.0) : Collections.emptyMap();
        return new ColumnMetaData(ColumnIdentifier.make(id, label, index), this.rowCount(), this.fieldTypeById(id), AggregationType.NONE, this.categoriesById(id), ColumnFormat.formatForString(), concepts);
    }

    private boolean roleContains(String role, String id) {
        JSONObject roles = JsonHelpers.getObject(this.json, "role");
        JSONArray roleIds = JsonHelpers.getArray(roles, role);
        return roleIds.contains((Object)id);
    }

    private JSONObject dimensionById(String id) {
        JSONObject dimensions = JsonHelpers.getObject(this.json, "dimension");
        if (!JsonHelpers.hasObjectKey(dimensions, id)) {
            throw new IllegalDataAccessRequest("Missing required dimension - id=" + id);
        }
        JSONObject dimension = JsonHelpers.getObject(dimensions, id);
        if (!JsonHelpers.hasObjectKey(dimension, "category")) {
            throw new IllegalDataAccessRequest("Missing categories for dimension - id=" + id);
        }
        return dimension;
    }

    private FieldType fieldTypeById(String id) {
        List<String> timeIds;
        JSONObject roles = JsonHelpers.getObject(this.json, "role");
        if (roles.containsKey((Object)"time") && (timeIds = JsonHelpers.getStringList(roles, "time")).contains(id)) {
            return FieldType.DATETIME;
        }
        JSONObject categories = JsonHelpers.getObject(this.dimensionById(id), "category");
        if (categories.containsKey((Object)"index") || categories.containsKey((Object)"label")) {
            return FieldType.CATEGORICAL;
        }
        throw new IllegalDataAccessRequest("Dimension categories must contain index or label");
    }

    private Map<String, List<Category>> categoriesById() {
        List<String> ids = JsonHelpers.getStringList(this.json, "id");
        return ids.stream().filter(id -> this.fieldTypeById((String)id) == FieldType.CATEGORICAL || this.fieldTypeById((String)id) == FieldType.DATETIME).collect(Collectors.toMap(Function.identity(), this::categoriesById, (prev, next) -> next, LinkedHashMap::new));
    }

    private List<Category> categoriesById(String dimensionId) {
        JSONObject catObj = JsonHelpers.getObject(this.dimensionById(dimensionId), "category");
        Map<String, String> categoryLabels = this.categoryLabels(dimensionId);
        if (JsonHelpers.hasArrayKey(catObj, "index")) {
            return JsonHelpers.getStringList(catObj, "index").stream().map(cat -> new Category(cat, categoryLabels.getOrDefault(cat, (String)cat))).collect(Collectors.toList());
        }
        if (JsonHelpers.hasObjectKey(catObj, "index")) {
            ArrayList<Category> categories = new ArrayList<Category>();
            JSONObject indices = JsonHelpers.getObject(catObj, "index");
            TreeMap<Integer, String> categoriesByIndices = new TreeMap<Integer, String>();
            for (String category : JsonHelpers.keys(indices)) {
                categoriesByIndices.put(JsonHelpers.getInt(indices, category), category);
            }
            categoriesByIndices.forEach((index, catId) -> {
                Category cat = new Category(catId, categoryLabels.getOrDefault(catId, (String)catId));
                categories.add(cat);
            });
            return categories;
        }
        if (JsonHelpers.hasObjectKey(catObj, "label") && categoryLabels.size() == 1) {
            return categoryLabels.entrySet().stream().map(entry -> new Category(entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }
        if (JsonHelpers.hasStringKey(catObj, "label")) {
            String label = JsonHelpers.getString(catObj, "label");
            return Collections.singletonList(new Category(label, label));
        }
        throw new IllegalDataAccessRequest("Dimension category is missing required index and label");
    }

    private Map<String, String> categoryLabels(String dimensionId) {
        JSONObject catObj = JsonHelpers.getObject(this.dimensionById(dimensionId), "category");
        if (!JsonHelpers.hasObjectKey(catObj, "label")) {
            return Collections.emptyMap();
        }
        JSONObject labelObj = JsonHelpers.getObject(catObj, "label");
        return JsonHelpers.keys(labelObj).stream().collect(Collectors.toMap(Function.identity(), key -> JsonHelpers.getString(labelObj, key)));
    }

    private int rowCount() {
        return JsonHelpers.hasArrayKey(this.json, VALUES_COLUMN_ID) ? JsonHelpers.getArray(this.json, VALUES_COLUMN_ID).size() : JsonHelpers.getObject(this.json, VALUES_COLUMN_ID).size();
    }

    private int[] indexToIndices(int index, List<Integer> sizes) {
        int i;
        int[] indices = new int[sizes.size()];
        int[] cSizes = new int[sizes.size()];
        cSizes[cSizes.length - 1] = 1;
        for (i = cSizes.length - 2; i >= 0; --i) {
            cSizes[i] = cSizes[i + 1] * sizes.get(i + 1);
        }
        for (i = 0; i < sizes.size(); ++i) {
            indices[i] = index / cSizes[i];
            index %= cSizes[i];
        }
        return indices;
    }
}

