/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder;

import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.dataaccess.jsonstat.JsonStat;
import com.ibm.bi.predict.exceptions.BadParametersException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class JsonStatValidator {
    private static final String VERSION_KEY = "version";
    private static final String ID_KEY = "id";
    private static final String SIZE_KEY = "size";
    private static final String VALUE_KEY = "value";
    private static final String ROLE_KEY = "role";
    private static final String DIMENSION_KEY = "dimension";
    private static final String CATEGORY_KEY = "category";
    private static final String INDEX_KEY = "index";
    private static final String LABEL_KEY = "label";
    private static final String TIME_KEY = "time";
    JSONObject json;

    private JsonStatValidator(JSONObject json) {
        this.json = json;
    }

    public static JsonStatValidator make(JSONObject json) {
        return new JsonStatValidator(json);
    }

    public void validate() {
        this.validateRequiredKeys();
        this.validateTypes();
        this.validateVersion();
        this.validateId();
        this.validateSize();
        this.validateValue();
        this.validateRole();
        this.validateDimension();
    }

    private void validateRequiredKeys() {
        String[] requiredKeys = new String[]{VERSION_KEY, ID_KEY, SIZE_KEY, VALUE_KEY, ROLE_KEY, DIMENSION_KEY};
        Arrays.stream(requiredKeys).forEach(key -> {
            if (!this.json.containsKey(key)) {
                throw new BadParametersException("Missing required JSON stat property - key=" + key);
            }
        });
    }

    private void validateVersion() {
        String version = JsonHelpers.getString(this.json, VERSION_KEY);
        if (!JsonStat.SUPPORTED_VERSIONS.contains(version)) {
            throw new BadParametersException(String.format("Unsupported json stat version %s", version));
        }
    }

    private void validateTypes() {
        if (!JsonHelpers.hasStringKey(this.json, VERSION_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=version");
        }
        if (this.json.containsKey((Object)"class") && !JsonHelpers.hasStringKey(this.json, "class")) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=class");
        }
        if (!JsonHelpers.hasArrayKey(this.json, VALUE_KEY) && !JsonHelpers.hasObjectKey(this.json, VALUE_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=value");
        }
        if (!JsonHelpers.hasArrayKey(this.json, ID_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=id");
        }
        if (!JsonHelpers.hasArrayKey(this.json, SIZE_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=size");
        }
        if (this.json.containsKey((Object)ROLE_KEY) && !JsonHelpers.hasObjectKey(this.json, ROLE_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=role");
        }
        if (!JsonHelpers.hasObjectKey(this.json, DIMENSION_KEY)) {
            throw new BadParametersException("Unsupported format for JSON stat property - key=dimension");
        }
    }

    private void validateId() {
        JSONArray idArray = JsonHelpers.getArray(this.json, ID_KEY);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idArray.size(); ++i) {
            String id = JsonHelpers.getString(idArray, i);
            if (idSet.contains(id)) {
                throw new BadParametersException(String.format("Duplicate id [%s]", id));
            }
            idSet.add(id);
        }
    }

    private void validateValue() {
        int maxSize = this.maxValueSize();
        if (this.isDenseMode()) {
            this.validateValueDense(maxSize);
        } else {
            this.validateValueSparse(maxSize);
        }
    }

    private void validateValueDense(int maxSize) {
        JSONArray values = JsonHelpers.getArray(this.json, VALUE_KEY);
        if (maxSize != values.size()) {
            throw new BadParametersException("Invalid number of values in values array. In dense mode it should be: " + maxSize);
        }
    }

    private void validateValueSparse(int maxSize) {
        JSONObject valueObj = JsonHelpers.getObject(this.json, VALUE_KEY);
        Iterator it = valueObj.keys();
        while (it.hasNext()) {
            int ordinal = Integer.parseInt((String)it.next());
            if (ordinal < maxSize) continue;
            throw new BadParametersException(String.format("Value ordinal out of range: %d. Valid range is [%d, %d]", ordinal, 0, maxSize - 1));
        }
    }

    public void validateSize() {
        if (JsonHelpers.getArray(this.json, ID_KEY).size() != JsonHelpers.getArray(this.json, SIZE_KEY).size()) {
            throw new BadParametersException("Size of id and size arrays don't match");
        }
    }

    public void validateRole() {
        JSONObject role = JsonHelpers.getObject(this.json, ROLE_KEY);
        if (!JsonHelpers.hasArrayKey(role, TIME_KEY)) {
            throw new BadParametersException("A time role is required");
        }
        JSONArray timeRole = JsonHelpers.getArray(role, TIME_KEY);
        if (timeRole.isEmpty()) {
            throw new BadParametersException("At least one dimension with the time role is required");
        }
        Set<String> idSet = JsonHelpers.getStringSet(this.json, ID_KEY);
        for (int i = 0; i < timeRole.size(); ++i) {
            String timeDimension = JsonHelpers.getString(timeRole, i);
            if (idSet.contains(timeDimension)) continue;
            throw new BadParametersException(String.format("Dimension id [%s] in time role does not match any value in the id array", timeDimension));
        }
    }

    public void validateDimension() {
        JSONArray idArray = JsonHelpers.getArray(this.json, ID_KEY);
        HashSet<String> idSet = new HashSet<String>();
        JSONObject dimensionObj = JsonHelpers.getObject(this.json, DIMENSION_KEY);
        for (int i = 0; i < idArray.size(); ++i) {
            String id = JsonHelpers.getString(idArray, i);
            idSet.add(id);
            this.validateDimensionId(dimensionObj, id, i);
        }
        if (dimensionObj.size() > idArray.size()) {
            for (String key : JsonHelpers.keys(dimensionObj)) {
                if (idSet.contains(key)) continue;
                throw new BadParametersException(String.format("Dimension id [%s] does not match any value in the id array", key));
            }
        }
    }

    private void validateDimensionId(JSONObject dimensionObj, String id, int idx) {
        if (!dimensionObj.containsKey((Object)id)) {
            throw new BadParametersException(String.format("Id [%s] not found in dimension object", id));
        }
        this.validateCategory(JsonHelpers.getObject(dimensionObj, id), id, idx);
    }

    private void validateCategory(JSONObject dimensionId, String id, int idx) {
        if (!dimensionId.containsKey((Object)CATEGORY_KEY)) {
            throw new BadParametersException(String.format("Dimension %s does not contain a category key", id));
        }
        JSONObject category = JsonHelpers.getObject(dimensionId, CATEGORY_KEY);
        this.validateIndex(category, id, idx);
        this.validatCategoryLabel(category, id, idx, false);
    }

    private void validateIndex(JSONObject category, String id, int idx) {
        if (!category.containsKey((Object)INDEX_KEY)) {
            this.validatCategoryLabel(category, id, idx, true);
            return;
        }
        if (JsonHelpers.hasArrayKey(category, INDEX_KEY)) {
            this.validateIndexArray(JsonHelpers.getArray(category, INDEX_KEY), id, idx);
        } else if (JsonHelpers.hasObjectKey(category, INDEX_KEY)) {
            this.validateIndexObject(JsonHelpers.getObject(category, INDEX_KEY), id, idx);
        } else {
            throw new BadParametersException("Unsupported format index property in dimension " + id);
        }
    }

    private void validateIndexArray(JSONArray index, String id, int idx) {
        int dimSize = this.dimensionSize(idx);
        if (index.size() != dimSize) {
            throw new BadParametersException(String.format("Invalid number of categories for dimension %s. It should be: %d", id, dimSize));
        }
    }

    private void validateIndexObject(JSONObject index, String id, int idx) {
        int dimSize = this.dimensionSize(idx);
        if (index.size() != dimSize) {
            throw new BadParametersException(String.format("Invalid number of categories for dimension %s. It should be: %d", id, dimSize));
        }
        Iterator it = index.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (JsonHelpers.getInt(index, key) < dimSize) continue;
            throw new BadParametersException(String.format("Index out of range for dimension %s and member %s. Valid range is [0, %d]", id, key, dimSize - 1));
        }
    }

    private void validatCategoryLabel(JSONObject category, String id, int idx, boolean required) {
        if (JsonHelpers.hasObjectKey(category, LABEL_KEY)) {
            JSONObject label = JsonHelpers.getObject(category, LABEL_KEY);
            JSONArray sizeArray = JsonHelpers.getArray(this.json, SIZE_KEY);
            if (required && label.size() != 1) {
                throw new BadParametersException(String.format("Invalid number of labels for dimension %s. It should be 1 when there is no index element", id));
            }
            if (label.size() != JsonHelpers.getInt(sizeArray, idx)) {
                throw new BadParametersException(String.format("Number of labels for dimension %s does not match size [%d] in the size array", id, JsonHelpers.getInt(sizeArray, idx)));
            }
        } else if (required) {
            throw new BadParametersException(String.format("Category label is required for dimension %s", id));
        }
    }

    private int maxValueSize() {
        return JsonHelpers.getIntList(this.json, SIZE_KEY).stream().reduce(1, (s1, s2) -> s1 * s2);
    }

    private boolean isDenseMode() {
        return JsonHelpers.hasArrayKey(this.json, VALUE_KEY);
    }

    private int dimensionSize(int idx) {
        JSONArray sizeArray = JsonHelpers.getArray(this.json, SIZE_KEY);
        int dimSize = JsonHelpers.getInt(sizeArray, idx);
        return dimSize;
    }

    private boolean isNumber(Object obj) {
        return obj instanceof Integer;
    }
}

