/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SourceFromDataAccessProvider {
    private final DataAccessProvider provider;
    private final MetaData providerMeta;

    public static final DataSource make(DataAccessProvider provider) {
        SourceFromDataAccessProvider converter = new SourceFromDataAccessProvider(provider);
        return new DataSource(converter.makeMeta(), null, null);
    }

    public SourceFromDataAccessProvider(DataAccessProvider provider) {
        this.provider = provider;
        this.providerMeta = provider.getMetaData();
    }

    public static ColumnIdentifier makeForPair(String id1, String id2, String label, int index) {
        return new ColumnIdentifier(new Tuple((Object)id1, (Object)id2), label, index);
    }

    private SourceMetaData makeMeta() {
        MetaData providerMeta = this.provider.getMetaData();
        List<ColumnMetaData> columnMetaData = IntStream.range(0, providerMeta.fieldCount()).mapToObj(this::makeColumnMetaData).collect(Collectors.toList());
        return new SourceMetaData(columnMetaData, Collections.emptySet(), Collections.emptySet());
    }

    private ColumnMetaData makeColumnMetaData(int columnIndex) {
        int rowCount = this.providerMeta.rowCount();
        Map<String, Double> concepts = this.providerMeta.getConcepts(columnIndex).stream().collect(Collectors.toMap(t -> (String)t._1, t -> (Double)t._2));
        FieldType fieldType = this.providerMeta.getFieldType(columnIndex);
        AggregationType aggregation = this.providerMeta.getFieldAggregation(columnIndex);
        List<Category> categories = this.makeCategories(columnIndex);
        return new ColumnMetaData(this.makeIdentifier(columnIndex), rowCount, fieldType, aggregation, categories, this.makeFormatFor(columnIndex), concepts);
    }

    private List<Category> makeCategories(int columnIndex) {
        return null;
    }

    private ColumnIdentifier makeIdentifier(int columnIndex) {
        return null;
    }

    private ColumnFormat makeFormatFor(int columnIndex) {
        return null;
    }
}

