/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import com.ibm.bi.predict.source.builder.csv.DeducedDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AutoDateFormat {
    public final DeducedDateFormat[] candidateFormats;

    public AutoDateFormat(Locale locale) {
        this.candidateFormats = new DeducedDateFormat[]{new DeducedDateFormat("u-M-d'T'H:m:s.SSS", Locale.US, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("u-M-d'T'H:m:s", Locale.US, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("u-M-d'T'H:m", Locale.US, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("uuuu-MM-dd HH:mm:ss", Locale.US, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("HH:mm:ss.SSS", Locale.US, LocalTime::from, "Time"), new DeducedDateFormat("H:m:s", Locale.US, LocalTime::from, "Time"), new DeducedDateFormat("MMM d, uuuu H:m:s", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("u-M-d", locale, LocalDate::from, "Date"), new DeducedDateFormat("d-M-u", locale, LocalDate::from, "Date"), new DeducedDateFormat("MMM d, uuuu", locale, LocalDate::from, "Date"), new DeducedDateFormat("M/d/u H:m:s", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("d/M/u H:m:s", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("M-d-u H:m:s", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("M/d/u H:m", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("d-M-u H:m:s", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("d/M/u H:m", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("M-d-u H:m", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("d-M-u H:m", locale, ZonedDateTime::from, "DateTime"), new DeducedDateFormat("M/d/u", locale, LocalDate::from, "Date"), new DeducedDateFormat("d/M/u", locale, LocalDate::from, "Date"), new DeducedDateFormat("u-M", locale, YearMonth::from, "YearMonth"), new DeducedDateFormat("MMM d", locale, MonthDay::from, "YearMonth"), new DeducedDateFormat("d-M-u", locale, LocalDate::from, "Date"), new DeducedDateFormat("M/d", locale, MonthDay::from, "DayOfYear"), new DeducedDateFormat("H:m", locale, LocalTime::from, "Time"), new DeducedDateFormat("MMMM", locale, Month::from, "Month"), new DeducedDateFormat("MMM", locale, Month::from, "Month"), new DeducedDateFormat("EEEE", locale, DayOfWeek::from, "DayOfWeek"), new DeducedDateFormat("EEE", locale, DayOfWeek::from, "DayOfWeek")};
    }

    public Optional<DeducedDateFormat> findBest(Stream<String> items) {
        List possibles = Arrays.stream(this.candidateFormats).map(x$0 -> new PossibleFormat((DeducedDateFormat)x$0)).collect(Collectors.toList());
        items.forEach(s -> this.considerPossibleFormats(possibles, (String)s));
        if (possibles.isEmpty()) {
            return Optional.empty();
        }
        PossibleFormat best = (PossibleFormat)possibles.get(0);
        for (PossibleFormat possible : possibles) {
            if (possible.successes <= best.successes) continue;
            best = possible;
        }
        if (best.successes > 0) {
            return Optional.ofNullable(best.format);
        }
        return Optional.empty();
    }

    private void considerPossibleFormats(List<PossibleFormat> formats, String text) {
        if (text == null || text.isEmpty() || formats.isEmpty()) {
            return;
        }
        Iterator<PossibleFormat> it = formats.iterator();
        while (it.hasNext()) {
            PossibleFormat possible = it.next();
            if (text.equals(possible.exception)) continue;
            if (possible.format.canParse(text)) {
                ++possible.successes;
                continue;
            }
            if (possible.exception == null) {
                possible.exception = text;
                continue;
            }
            it.remove();
        }
    }

    private static final class PossibleFormat {
        final DeducedDateFormat format;
        String exception;
        int successes;

        private PossibleFormat(DeducedDateFormat format) {
            this.format = format;
        }
    }
}

