/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import com.ibm.bi.predict.source.ColumnIdentifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ColumnNaming {
    private final ColumnIdentifier[] identifiers;
    private final boolean usedFirstLine;

    ColumnNaming(int size, Iterator<String> it) {
        this.identifiers = new ColumnIdentifier[size];
        HashSet<String> existingIdentifiers = new HashSet<String>();
        for (int i = 0; i < this.identifiers.length; ++i) {
            String name = it.next().trim();
            String id = this.ensureUnique(name, i, existingIdentifiers);
            this.identifiers[i] = new ColumnIdentifier(id, name, i);
        }
        this.usedFirstLine = true;
    }

    ColumnNaming(int size) {
        this.identifiers = new ColumnIdentifier[size];
        for (int i = 0; i < this.identifiers.length; ++i) {
            String id = "C" + (i + 1);
            this.identifiers[i] = new ColumnIdentifier(id, "", i);
        }
        this.usedFirstLine = false;
    }

    public String toString() {
        return Arrays.toString(this.names());
    }

    int columnCount() {
        return this.identifiers.length;
    }

    ColumnIdentifier[] names() {
        return this.identifiers;
    }

    boolean usedFirstLine() {
        return this.usedFirstLine;
    }

    private String ensureUnique(String name, int index, Set<String> existingIdentifiers) {
        if (name == null || name.isEmpty()) {
            name = "C" + (index + 1);
        }
        if (existingIdentifiers.add(name)) {
            return name;
        }
        int ext = 1;
        while (!existingIdentifiers.add(name + "_" + ext)) {
            ++ext;
        }
        return name + "_" + ext;
    }
}

