/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import com.ibm.bi.predict.source.Category;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Locale;

public class DeducedDateFormat {
    private static final String CONCEPT_PREFIX = "http://www.ibm.com/ontologies/waca/domain/common#";
    private final String pattern;
    private final TemporalQuery<TemporalAccessor> toTemporal;
    private final String conceptName;
    private final DateTimeFormatter formatter;

    public DeducedDateFormat(String pattern, Locale locale, TemporalQuery<TemporalAccessor> toTemporal, String conceptShortName) {
        this.pattern = pattern;
        this.toTemporal = toTemporal;
        this.conceptName = CONCEPT_PREFIX + conceptShortName;
        this.formatter = DateTimeFormatter.ofPattern(pattern, locale).withZone(ZoneId.of("UTC")).withResolverStyle(ResolverStyle.STRICT);
    }

    public boolean canParse(String text) {
        try {
            return this.parse(text) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Category parseDate(Object o) {
        if (o == null) {
            return null;
        }
        try {
            String text = o.toString();
            TemporalAccessor parsedFormat = this.parse(text);
            return new Category(parsedFormat, text);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String pattern() {
        return this.pattern;
    }

    public String conceptName() {
        return this.conceptName;
    }

    private TemporalAccessor parse(String text) {
        return this.formatter.parse((CharSequence)text, this.toTemporal);
    }
}

