/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.csv;

import com.ibm.bi.predict.data.store.DataArray;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.builder.csv.DeducedDateFormat;
import com.ibm.bi.predict.source.builder.csv.IndexedRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SourceComponentsToDataSource {
    private final List<Object[]> rows;

    public SourceComponentsToDataSource(List<Object[]> rows) {
        this.rows = rows;
    }

    public Collection<Row> makeRows(List<ColumnMetaData> meta) {
        int n = meta.size();
        List[] categories = (List[])meta.stream().map(ColumnMetaData::categories).toArray(List[]::new);
        DataArray[] columns = (DataArray[])IntStream.range(0, n).parallel().mapToObj(c -> this.makeColumn(c, categories[c], this.rows)).toArray(DataArray[]::new);
        IndexedRow.Common common = new IndexedRow.Common(columns, categories);
        return IntStream.range(0, this.rows.size()).mapToObj(r -> new IndexedRow(r, common)).collect(Collectors.toList());
    }

    public SourceMetaData makeMetaData(ColumnIdentifier[] names, DeducedDateFormat[] dateFormats, Integer[] numericPlaces) {
        List<ColumnMetaData> columns = IntStream.range(0, names.length).mapToObj(i -> this.makeColumnMetaData(names[i], dateFormats[i], numericPlaces[i])).collect(Collectors.toList());
        return new SourceMetaData(columns);
    }

    private ColumnMetaData makeColumnMetaData(ColumnIdentifier id, DeducedDateFormat dateFormat, Integer numericPlaces) {
        Map<String, Double> concepts;
        List<Category> categories;
        ColumnFormat format;
        FieldType type;
        if (dateFormat != null) {
            type = FieldType.DATETIME;
            format = ColumnFormat.formatForDate(dateFormat.pattern());
            categories = this.distinctCategories(id.index());
            concepts = Collections.singletonMap(dateFormat.conceptName(), 1.0);
        } else if (numericPlaces != null) {
            type = FieldType.NUMERICAL;
            format = ColumnFormat.formatForNumber(numericPlaces, null, null);
            categories = null;
            concepts = Collections.emptyMap();
        } else {
            type = FieldType.CATEGORICAL;
            format = ColumnFormat.formatForString();
            categories = this.distinctCategories(id.index());
            concepts = Collections.emptyMap();
        }
        return new ColumnMetaData(id, this.rows.size(), type, AggregationType.NONE, categories, format, concepts);
    }

    private DataArray makeColumn(int columnIndex, List<Category> categories, List<Object[]> rows) {
        double[] data = new double[rows.size()];
        if (categories == null) {
            for (int i = 0; i < data.length; ++i) {
                Number value = (Number)rows.get(i)[columnIndex];
                data[i] = value == null ? Double.NaN : value.doubleValue();
            }
        } else {
            HashMap<Category, Double> valueToIndex = new HashMap<Category, Double>();
            int n = 0;
            for (Category category : categories) {
                valueToIndex.put(category, Double.valueOf(n++));
            }
            for (int i = 0; i < data.length; ++i) {
                Category value = (Category)rows.get(i)[columnIndex];
                data[i] = valueToIndex.getOrDefault(value, Double.NaN);
            }
        }
        return DataArray.of(data);
    }

    private List<Category> distinctCategories(int i) {
        LinkedHashSet<Category> result = new LinkedHashSet<Category>();
        for (Object[] row : this.rows) {
            Category c = (Category)row[i];
            if (c == null) continue;
            result.add(c);
        }
        return new ArrayList<Category>(result);
    }
}

