/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.source.builder.endorresultset.EndorItemClass;
import com.ibm.bi.predict.source.builder.endorresultset.EndorItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EndorDataItem {
    private final EndorItemClass itemClass;
    private final Optional<EndorItems> items;

    private EndorDataItem(EndorItemClass itemClass, Optional<EndorItems> items) {
        this.itemClass = itemClass;
        this.items = items;
    }

    public EndorItemClass itemClass() {
        return this.itemClass;
    }

    public Optional<EndorItems> items() {
        return this.items;
    }

    public static List<EndorDataItem> parse(JSONObject dataItem) throws JSONException {
        ArrayList<EndorDataItem> result = new ArrayList<EndorDataItem>();
        List<EndorItemClass> ids = EndorItemClass.parse(dataItem.getJSONObject("itemClass"));
        JSONArray itemsArray = dataItem.optJSONArray("items", null);
        if (itemsArray == null) {
            for (int i = 0; i < ids.size(); ++i) {
                result.add(new EndorDataItem(ids.get(i), Optional.empty()));
            }
        } else if (itemsArray.isEmpty()) {
            Optional<EndorItems> items = Optional.of(EndorItems.empty());
            for (int i = 0; i < ids.size(); ++i) {
                result.add(new EndorDataItem(ids.get(i), items));
            }
        } else {
            List<EndorItems> cats = EndorItems.parse(itemsArray);
            if (cats.size() != ids.size()) {
                throw new JSONException("itemClass and items do not agree in number of columns");
            }
            for (int i = 0; i < ids.size(); ++i) {
                result.add(new EndorDataItem(ids.get(i), Optional.of(cats.get(i))));
            }
        }
        return result;
    }

    public static List<List<EndorDataItem>> parse(JSONArray dataItems) throws JSONException {
        ArrayList<List<EndorDataItem>> result = new ArrayList<List<EndorDataItem>>();
        for (int i = 0; i < dataItems.size(); ++i) {
            result.add(EndorDataItem.parse(dataItems.getJSONObject(i)));
        }
        return result;
    }
}

