/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.source.builder.endorresultset;

import com.ibm.bi.predict.dataaccess.types.AggregationType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EndorItemClass {
    private final String groupId;
    private final String itemId;
    private final String dataId;
    private final String label;
    private final AggregationType aggregate;

    private EndorItemClass(String groupId, String itemId, String dataId, String label, AggregationType aggregate) {
        this.groupId = groupId;
        this.itemId = itemId;
        this.dataId = dataId;
        this.label = label;
        this.aggregate = aggregate;
    }

    public String groupId() {
        return this.groupId;
    }

    public String itemId() {
        return this.itemId;
    }

    public String dataId() {
        return this.dataId;
    }

    public String label() {
        return this.label;
    }

    public AggregationType aggregate() {
        return this.aggregate;
    }

    public String toString() {
        return this.itemId;
    }

    public static List<EndorItemClass> parse(JSONObject itemClass) throws JSONException {
        ArrayList<EndorItemClass> result = new ArrayList<EndorItemClass>();
        String groupId = itemClass.optString("id", null);
        JSONArray h = itemClass.getJSONArray("h");
        for (int i = 0; i < h.size(); ++i) {
            JSONObject o = h.getJSONObject(i);
            result.add(EndorItemClass.createId(groupId, o.optString("id", null), o.optString("u", null), o.optString("d", null), o.optString("aggregate", null)));
        }
        return result;
    }

    private static EndorItemClass createId(String groupId, String itemId, String dataId, String label, String aggregate) throws JSONException {
        String dval;
        String string = itemId != null ? itemId : (groupId != null ? groupId : (dval = dataId != null ? dataId : label));
        if (dval == null) {
            throw new JSONException("All of the id, u, and d properties of an itemClass are null");
        }
        return new EndorItemClass(groupId != null ? groupId : dval, itemId != null ? itemId : dval, dataId != null ? dataId : dval, label != null ? label : dval, AggregationType.fromString((String)aggregate));
    }
}

