/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness.datadriven;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.csv.CSVDataAccessProvider;
import com.ibm.bi.predict.testharness.TaskParameters;
import java.util.function.Function;

public abstract class DataAccessProviderAction
implements Function<TaskParameters, String> {
    private Function<TaskParameters, DataAccessProvider> providerFunc;
    private final String result;

    protected DataAccessProviderAction(Function<TaskParameters, DataAccessProvider> providerFunc, String result) {
        this.providerFunc = providerFunc;
        this.result = result;
    }

    protected DataAccessProviderAction(DataAccessProvider provider, String result) {
        this.providerFunc = t -> provider;
        this.result = result;
    }

    protected DataAccessProviderAction(String filename, String result) {
        this.providerFunc = t -> DataAccessProviderAction.loadFile(filename);
        this.result = result;
    }

    private static DataAccessProvider loadFile(String filename) {
        try {
            return new CSVDataAccessProvider(filename, filename.toLowerCase().endsWith(".zip"));
        }
        catch (Exception e) {
            throw new RuntimeException("File " + filename + " not loaded", e);
        }
    }

    @Override
    public String apply(TaskParameters t) {
        if (t.content.containsKey("file")) {
            this.runTask(this.providerFunc.apply(t), t);
            return this.result;
        }
        throw new RuntimeException("Invalid Task Parameters. No file specified");
    }

    public abstract void runTask(DataAccessProvider var1, TaskParameters var2);
}

