/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness.datadriven;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.csv.CSVDataAccessProvider;
import com.ibm.bi.predict.testharness.TaskParameters;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class SingleDataAccessProviderAction
implements Function<TaskParameters, DataAccessProvider> {
    private final boolean reuseProviders;
    private final String path;
    private final Map<String, DataAccessProvider> providers;

    public SingleDataAccessProviderAction(String path) {
        this(path, false);
    }

    public SingleDataAccessProviderAction(String path, boolean reuseProviders) {
        this.reuseProviders = reuseProviders;
        this.path = path;
        this.providers = new HashMap<String, DataAccessProvider>();
    }

    @Override
    public DataAccessProvider apply(TaskParameters t) {
        if (t.content.containsKey("file")) {
            String filename = ((Comparable)t.content.get("file")).toString();
            if (this.reuseProviders) {
                if (!this.providers.containsKey(filename)) {
                    this.providers.put(filename, this.createCSVProvider(filename));
                }
                return this.providers.get(filename);
            }
            return this.createCSVProvider(filename);
        }
        throw new RuntimeException("No file name found.");
    }

    private DataAccessProvider createCSVProvider(String filename) {
        try {
            return new CSVDataAccessProvider(this.path + filename, filename.toLowerCase().endsWith(".zip"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load file " + filename);
        }
    }
}

