/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.util;

import com.ibm.bi.predict.utils.Count;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableDouble;

public class TableWriter {
    private final DecimalFormat SCIENTIFIC = new DecimalFormat("0.######E0");
    private final Map<Integer, DecimalFormat> FIXED_FORMATS = new HashMap<Integer, DecimalFormat>();
    private static final int MAX_PRINT_WIDTH = 100;
    private final List<String> columnHeadings;
    private final List<String> postTableComments;
    private final List<List<Object>> rows;
    private Function<Number, String> numberToStringFunction;
    private Function<String, String> stringToStringFunction;
    private Function<Date, String> dateToStringFunction;
    private Function<Object, String> unknownTypeToStringFunction;
    private SimpleDateFormat dateFormat;

    public TableWriter() {
        this.prepareDateFormat();
        this.numberToStringFunction = this::formatNumber;
        this.stringToStringFunction = Function.identity();
        this.dateToStringFunction = this::formatDate;
        this.unknownTypeToStringFunction = o -> o == null ? null : o.toString();
        this.columnHeadings = new ArrayList<String>();
        this.postTableComments = new ArrayList<String>();
        this.rows = new ArrayList<List<Object>>();
    }

    public TableWriter addPostTableComment(String ... items) {
        Collections.addAll(this.postTableComments, items);
        return this;
    }

    public TableWriter addToHeader(String ... items) {
        Collections.addAll(this.columnHeadings, items);
        return this;
    }

    public TableWriter addToRow(Object ... items) {
        if (this.rows.isEmpty()) {
            this.newRow();
        }
        List<Object> row = this.rows.get(this.rows.size() - 1);
        Collections.addAll(row, items);
        return this;
    }

    public Function<Date, String> dateToStringFunction() {
        return this.dateToStringFunction;
    }

    public TableWriter dateToStringFunction(Function<Date, String> dateToStringFunction) {
        this.dateToStringFunction = dateToStringFunction;
        return this;
    }

    public TableWriter newRow() {
        this.rows.add(new ArrayList());
        return this;
    }

    public Function<Number, String> numberToStringFunction() {
        return this.numberToStringFunction;
    }

    public TableWriter numberToStringFunction(Function<Number, String> numberToStringFunction) {
        this.numberToStringFunction = numberToStringFunction;
        return this;
    }

    public TableWriter printAsCSV(PrintStream out) {
        int n = this.findConsistentColumnCount();
        List<String> names = this.columnHeadings.isEmpty() ? IntStream.rangeClosed(1, n).mapToObj(i -> "C" + i).collect(Collectors.toList()) : this.columnHeadings;
        this.printAsCSV(names.stream(), out);
        for (List<Object> row : this.rows) {
            out.println();
            this.printAsCSV(row.stream().map(this::stringOf), out);
        }
        this.printPostTableComments(out);
        return this;
    }

    public TableWriter printTable(PrintStream out) {
        return this.printTable(out, 100);
    }

    public TableWriter printTable(PrintStream out, int maxWidth) {
        int n = this.findConsistentColumnCount();
        int[] widths = this.findBestColumnWidthsForRows(maxWidth, n);
        List<String> names = this.columnHeadings.isEmpty() ? IntStream.rangeClosed(1, n).mapToObj(i -> "C" + i).collect(Collectors.toList()) : this.columnHeadings;
        this.printLine(names, out, widths);
        for (List<Object> row : this.rows) {
            List<String> rowTexts = row.stream().map(this::stringOf).collect(Collectors.toList());
            out.println();
            this.printLine(rowTexts, out, widths);
        }
        this.printPostTableComments(out);
        return this;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public Function<String, String> stringToStringFunction() {
        return this.stringToStringFunction;
    }

    public TableWriter stringToStringFunction(Function<String, String> stringToStringFunction) {
        this.stringToStringFunction = stringToStringFunction;
        return this;
    }

    public Function<Object, String> unknownTypeToStringFunction() {
        return this.unknownTypeToStringFunction;
    }

    public TableWriter unknownTypeToStringFunction(Function<Object, String> unknownTypeToStringFunction) {
        this.unknownTypeToStringFunction = unknownTypeToStringFunction;
        return this;
    }

    private void printPostTableComments(PrintStream out) {
        if (!this.postTableComments.isEmpty()) {
            out.println();
            out.println();
            for (String postTableComment : this.postTableComments) {
                out.format("%n\t%s", postTableComment);
            }
        }
    }

    private int[] findBestColumnWidthsForRows(int maxWidth, int n) {
        int[] prefSize = new int[n];
        int[] okSize = new int[n];
        for (int c = 0; c < n; ++c) {
            Count counts = new Count();
            if (!this.columnHeadings.isEmpty()) {
                counts.increment((Comparable)Integer.valueOf(this.columnHeadings.get(c).length()));
            } else {
                counts.increment((Comparable)Integer.valueOf(3));
            }
            for (List<Object> row : this.rows) {
                String s = this.stringOf(row.get(c));
                counts.increment((Comparable)Integer.valueOf(s.length()));
            }
            prefSize[c] = counts.keySet().stream().mapToInt(i -> i).max().orElse(0);
            this.set90PercentTotal(okSize, c, (Count<Integer>)counts);
        }
        int sizeUsingPreferred = Arrays.stream(prefSize).sum() + (n - 1);
        if (sizeUsingPreferred > maxWidth) {
            this.reduceToFit(prefSize, okSize, maxWidth);
        }
        return prefSize;
    }

    private int findConsistentColumnCount() {
        int columnWidths = this.columnHeadings.size();
        Count rowWidths = Count.of(this.rows.stream(), List::size, r -> 1.0);
        if (rowWidths.isEmpty() && columnWidths == 0) {
            throw new IllegalStateException("Cannot write a table with no column headings or rows defined");
        }
        if (rowWidths.isEmpty()) {
            return columnWidths;
        }
        Integer mostFrequent = (Integer)rowWidths.mostFrequentEntry();
        if (rowWidths.size() > 1) {
            int mostFrequentCount = (int)rowWidths.get((Comparable)mostFrequent);
            String message = String.format("Inconsistent row widths; most (%d) had width %d, but %d rows had other lengths", mostFrequentCount, mostFrequent, (int)rowWidths.totalCount() - mostFrequentCount);
            throw new IllegalStateException(message);
        }
        if (columnWidths > 0 && mostFrequent != columnWidths) {
            String message = String.format("Column header length (%d) was inconsistent with row widths (%d)", columnWidths, mostFrequent);
            throw new IllegalStateException(message);
        }
        return mostFrequent;
    }

    private String formatNumber(Number number) {
        if (Math.abs((double)number.intValue() - number.doubleValue()) <= Double.MIN_VALUE) {
            return Integer.toString(number.intValue());
        }
        double a = Math.abs(number.doubleValue());
        if (a < 1.0E-5 || a > 1.0E7) {
            return this.SCIENTIFIC.format(number);
        }
        int integerPlaces = Math.max(0, (int)Math.ceil(Math.log10(a)));
        DecimalFormat f = this.FIXED_FORMATS.computeIfAbsent(integerPlaces, i -> {
            DecimalFormat format = new DecimalFormat();
            format.setMaximumFractionDigits(8 - integerPlaces);
            format.setGroupingUsed(false);
            return format;
        });
        return f.format(number);
    }

    private void prepareDateFormat() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    private void printAsCSV(Stream<String> stream, PrintStream out) {
        out.print(stream.map(StringEscapeUtils::escapeCsv).collect(Collectors.joining(",")));
    }

    private void printLine(List<String> names, PrintStream out, int[] widths) {
        for (int i = 0; i < widths.length; ++i) {
            String txt = names.get(i);
            if (txt.length() > widths[i]) {
                txt = txt.substring(0, widths[i] - 1) + "\u2026";
            }
            if (i == 0) {
                out.format("%" + widths[i] + "s", txt);
                continue;
            }
            out.format(" %" + widths[i] + "s", txt);
        }
    }

    private void reduceToFit(int[] widths, int[] okSize, int maxWidth) {
        int i;
        int largest;
        int excess;
        int n = widths.length;
        if (4 * n + (n - 1) > maxWidth) {
            throw new IllegalStateException(String.format("Too many fields (%d) to be shown in a width of %d", n, maxWidth));
        }
        for (excess = n - 1 + Arrays.stream(widths).sum() - maxWidth; excess > 0; --excess) {
            largest = 0;
            for (i = 1; i < widths.length; ++i) {
                if (widths[i] - okSize[i] < widths[largest] - okSize[largest]) continue;
                largest = i;
            }
            if (widths[largest] == okSize[largest]) break;
            int n2 = largest;
            widths[n2] = widths[n2] - 1;
        }
        while (excess > 0) {
            largest = 0;
            for (i = 1; i < widths.length; ++i) {
                if (widths[i] < widths[largest]) continue;
                largest = i;
            }
            int n3 = largest;
            widths[n3] = widths[n3] - 1;
            --excess;
        }
    }

    private void set90PercentTotal(int[] columnSizes, int columnIndex, Count<Integer> counts) {
        columnSizes[columnIndex] = (Integer)counts.mostFrequentEntry();
        MutableDouble counted = new MutableDouble(0.0);
        counts.stream().sorted().forEach(e -> {
            counted.add(e.count());
            if (counted.doubleValue() <= 0.9 * counts.totalCount()) {
                columnSizes[columnIndex] = Math.max(columnSizes[columnIndex], (Integer)e.item());
            }
        });
    }

    private String stringOf(Object o) {
        if (o instanceof Number) {
            return this.numberToStringFunction.apply((Number)o);
        }
        if (o instanceof String) {
            return this.stringToStringFunction.apply((String)o);
        }
        if (o instanceof Date) {
            return this.dateToStringFunction.apply((Date)o);
        }
        String s = this.unknownTypeToStringFunction.apply(o);
        return s == null ? "" : s;
    }
}

