/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acmath.accumstats.MeansXProdData;
import com.spss.math.matrix.DenseSymMatrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@FromCppClass(value="MCMATH_NAMESPACE::MCProvMeans")
public class ProvMeans
extends MeansXProdData
implements ACSerializable,
Cloneable {
    private static final long serialVersionUID = 2769263037176152361L;

    public ProvMeans() {
    }

    public ProvMeans(int nVars) {
        super(nVars);
    }

    public ProvMeans(int nVars, boolean hasIntercept) {
        super(nVars, hasIntercept);
    }

    public ProvMeans(ProvMeans other) {
        super(other);
    }

    public boolean update(double[] data, double weight) {
        double newNCases = this.nCases + weight;
        boolean result = data.length >= this.nVars;
        boolean bl = result = result && newNCases >= 0.0;
        if (result) {
            if (newNCases == 0.0) {
                super.clear();
            } else if (weight > 0.0) {
                super.addCase(data, weight);
            } else if (weight < 0.0) {
                super.deleteCase(data, -weight);
            }
        }
        return result;
    }

    public boolean update(double[] data, int[] indices, double weight) {
        double newNCases = this.nCases + weight;
        boolean result = indices[indices.length - 1] >= this.nVars;
        boolean bl = result = newNCases >= 0.0;
        if (result) {
            if (newNCases == 0.0) {
                super.clear();
            } else if (weight > 0.0) {
                super.addCase(data, indices, weight);
            } else if (weight < 0.0) {
                super.deleteCase(data, indices, -weight);
            }
        }
        return result;
    }

    public boolean update(double[] data) {
        return this.update(data, 1.0);
    }

    public boolean merge(ProvMeans other) {
        return super.merge(other);
    }

    @Override
    public boolean merge(Object[] others) {
        return super.merge(others);
    }

    @Override
    public double getNCases() {
        return super.getNCases();
    }

    @Override
    public double[] getMeans() {
        return super.getMeans();
    }

    @Override
    public DenseSymMatrix getXProds() {
        return super.getXProds();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nVars);
        dataOutput.writeBoolean(this.hasIntercept);
        dataOutput.writeDouble(this.nCases);
        ACSerializationUtils.writeDoubleArray((double[])this.meansArray, (DataOutput)dataOutput);
        ACSerializationUtils.writeObjectExistFlag((String)"DenseSymMatrix", (this.mXProds != null ? 1 : 0) != 0, (DataOutput)dataOutput);
        if (this.mXProds != null) {
            dataOutput.writeInt(this.mXProds.getNRows());
            ACSerializationUtils.writeDoubleArray((double[])this.mXProds.getMatrix(), (DataOutput)dataOutput);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nVars = dataInput.readInt();
        this.hasIntercept = dataInput.readBoolean();
        this.nCases = dataInput.readDouble();
        this.meansArray = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.mXProds = null;
        this.xProdsArray = null;
        if (ACSerializationUtils.readObjectExistFlag((String)"DenseSymMatrix", (DataInput)dataInput)) {
            this.mXProds = new DenseSymMatrix(dataInput.readInt());
            System.arraycopy(ACSerializationUtils.readDoubleArray((DataInput)dataInput), 0, this.mXProds.getMatrix(), 0, this.mXProds.getMatrix().length);
            this.xProdsArray = this.mXProds.getMatrix();
        }
        return this;
    }

    @Override
    public ProvMeans clone() {
        return (ProvMeans)super.clone();
    }
}

