/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.accumstats;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.acbase.tuple.Tuple2;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.AccumTestStats4CatTarget;
import com.spss.ac.acmath.accumstats.TwowayLRTestLReduced;
import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.RectMatrix;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class TwowayLRTestForCategTarget
implements ACSerializable,
AccumTestStats4CatTarget {
    private static final long serialVersionUID = 8773399963530636644L;
    private int nTargetCategs = 0;
    private int nTargetCategsAdjusted = 0;
    private int nFactor1Categs = 0;
    private int nFactor2Categs = 0;
    private int nCells = 0;
    private int targetX = -1;
    private int factor1X = -1;
    private int factor2X = -1;
    private int weightX = -1;
    private DenseRectMatrix mNRecs = null;
    private double[] arrNRecs = null;
    private DenseRectMatrix mNRecsAdjusted = null;
    private double[] arrNRecsAdjusted = null;
    private double[] nRecsTargetCateg = null;
    private int[] validTargetCateg = null;
    private double[] nRecsFactorCateg = null;
    private int validUpdCnt = 0;
    private int invalidUpdCnt = 0;
    private double totalNRecs = 0.0;
    private double validNRecs = 0.0;
    private double lFull = 0.0;
    private double lReduced = 0.0;
    private double lIntercept = 0.0;
    private double chiSquare = MissingValue.getMissing();
    private double dfEffect = MissingValue.getMissing();
    private double dfFull = MissingValue.getMissing();
    private double pValue = MissingValue.getMissing();
    private double accuracy = MissingValue.getMissing();
    private double fitMeasure2 = MissingValue.getMissing();
    private double effectSize = MissingValue.getMissing();
    private double interestingness = MissingValue.getMissing();
    private int maxIterOuter = 100;
    private double tolOuter = 1.0E-6;
    private int maxIterInner = 5;
    private double tolInner = 1.0E-6;
    private Tuple2<Double, Double> PIPairs = null;

    public TwowayLRTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, int targetX, int factor1X, int factor2X, int weightX) {
        this.nTargetCategs = nTargetCategs;
        this.nFactor1Categs = nFactor1Categs;
        this.nFactor2Categs = nFactor2Categs;
        this.targetX = targetX;
        this.factor1X = factor1X;
        this.factor2X = factor2X;
        this.weightX = weightX;
        this.nCells = nFactor1Categs * nFactor2Categs;
        this.mNRecs = new DenseRectMatrix(this.nCells, this.nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
    }

    public TwowayLRTestForCategTarget(int nTargetCategs, int nFactor1Categs, int nFactor2Categs, double[] arrNRecs, double[] nRecsTargetCateg, double[] nRecsFactorCateg, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        this.nTargetCategs = nTargetCategs;
        this.nFactor1Categs = nFactor1Categs;
        this.nFactor2Categs = nFactor2Categs;
        this.nCells = nFactor1Categs * nFactor2Categs;
        this.mNRecs = new DenseRectMatrix(this.nCells, this.nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
        MathFun.dCopy((double[])arrNRecs, (double[])this.arrNRecs);
        this.nRecsTargetCateg = new double[this.nTargetCategs];
        MathFun.dCopy((double[])nRecsTargetCateg, (double[])this.nRecsTargetCateg);
        this.nRecsFactorCateg = new double[this.nCells];
        MathFun.dCopy((double[])nRecsFactorCateg, (double[])this.nRecsFactorCateg);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
    }

    public TwowayLRTestForCategTarget() {
        this(0, 0, 0, -1, -1, -1, -1);
    }

    public void setNCategs(int nTargetCategs, int nFactor1Categs, int nFactor2Categs) {
        this.nTargetCategs = nTargetCategs;
        this.nFactor1Categs = nFactor1Categs;
        this.nFactor2Categs = nFactor2Categs;
        this.nCells = nFactor1Categs * nFactor2Categs;
        this.mNRecs = new DenseRectMatrix(this.nCells, this.nTargetCategs);
        this.arrNRecs = this.mNRecs.getMatrix();
    }

    @Override
    public void setAggregatedStatistics(double[] arrNRecs, double[] nRecsTargetCateg, double[] nRecsFactorCateg, int validNRecUnweighted, int invalidNRecUnweighted, double totalNRecs, double validNRecs) {
        MathFun.dCopy((double[])this.arrNRecs, (double[])arrNRecs);
        MathFun.dCopy((double[])this.nRecsTargetCateg, (double[])nRecsTargetCateg);
        MathFun.dCopy((double[])this.nRecsFactorCateg, (double[])nRecsFactorCateg);
        this.validUpdCnt = validNRecUnweighted;
        this.invalidUpdCnt = invalidNRecUnweighted;
        this.totalNRecs = totalNRecs;
        this.validNRecs = validNRecs;
    }

    @Override
    public int getNTargetCategs() {
        return this.nTargetCategs;
    }

    public int getNFactor1Categs() {
        return this.nFactor1Categs;
    }

    public int getNFactor2Categs() {
        return this.nFactor2Categs;
    }

    @Override
    public int getNFactorCategs() {
        return this.nCells;
    }

    public void setTargetIndex(int targetX) {
        this.targetX = targetX;
    }

    @Override
    public int getTargetIndex() {
        return this.targetX;
    }

    public void setFactor1Index(int factor1X) {
        this.factor1X = factor1X;
    }

    public int getFactor1Index() {
        return this.factor1X;
    }

    public void setFactor2Index(int factor2X) {
        this.factor2X = factor2X;
    }

    public int getFactor2Index() {
        return this.factor2X;
    }

    public void setWeightIndex(int weightX) {
        this.weightX = weightX;
    }

    @Override
    public int getWeightIndex() {
        return this.weightX;
    }

    @Override
    public DenseRectMatrix getNRecs() {
        return this.mNRecs;
    }

    @Override
    public DenseRectMatrix getObsProbs() {
        DenseRectMatrix mObsProbs = new DenseRectMatrix(this.nCells, this.nTargetCategsAdjusted);
        double[] arrObsProbs = mObsProbs.getMatrix();
        int elemX = 0;
        for (int iFac = 0; iFac < this.nCells; ++iFac) {
            double nRecsFac = this.nRecsFactorCateg[iFac];
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                arrObsProbs[elemX] = nRecsFac > 0.0 ? this.arrNRecsAdjusted[elemX] / nRecsFac : 0.0;
                ++elemX;
            }
        }
        return mObsProbs;
    }

    @Override
    public DenseRectMatrix getExpectedNRecs() {
        if (this.nRecsTargetCateg == null || this.validNRecs == 0.0) {
            return null;
        }
        DenseRectMatrix mExpectedNRecs = new DenseRectMatrix(this.nCells, this.nTargetCategsAdjusted);
        double[] targetProbs = new double[this.nTargetCategsAdjusted];
        for (int i = 0; i < this.nTargetCategsAdjusted; ++i) {
            targetProbs[i] = this.nRecsTargetCateg[this.validTargetCateg[i]] / this.validNRecs;
            for (int k = 0; k < this.nCells; ++k) {
                double expN = targetProbs[i] * this.nRecsFactorCateg[k];
                mExpectedNRecs.setElem(k, i, expN);
            }
        }
        return mExpectedNRecs;
    }

    @Override
    public double[] getNRecsTargetCateg() {
        return this.nRecsTargetCateg;
    }

    @Override
    public int[] getValidTargetCateg() {
        return this.validTargetCateg;
    }

    @Override
    public double[] getNRecsFactorCateg() {
        return this.nRecsFactorCateg;
    }

    @Override
    public int getValidUpdCnt() {
        return this.validUpdCnt;
    }

    @Override
    public int getInvalidUpdCnt() {
        return this.invalidUpdCnt;
    }

    @Override
    public int getUnweightedNRecs() {
        return this.validUpdCnt + this.invalidUpdCnt;
    }

    @Override
    public double getTotalNRecs() {
        return this.totalNRecs;
    }

    @Override
    public double getValidNRecs() {
        return this.validNRecs;
    }

    @Override
    public double getLFull() {
        return this.lFull;
    }

    @Override
    public double getLReduced() {
        return this.lReduced;
    }

    @Override
    public double getChiSquare() {
        return this.chiSquare;
    }

    @Override
    public double getDF() {
        return this.dfEffect;
    }

    public double getDFFull() {
        return this.dfFull;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    @Override
    public double getFitMeasure() {
        return this.accuracy;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public double getMcFaddenR2() {
        return this.fitMeasure2;
    }

    public Tuple2<Double, Double> getPIValues() {
        return this.PIPairs;
    }

    @Override
    public boolean update(double[] record, boolean validateFactorVal) {
        double targetValue = record[this.targetX];
        double factor1Value = record[this.factor1X];
        double factor2Value = record[this.factor2X];
        double weight = this.weightX >= 0 ? record[this.weightX] : 1.0;
        boolean result = true;
        if (validateFactorVal) {
            result = !MissingValue.isMissing((double)factor1Value) && !MissingValue.isMissing((double)factor2Value);
        }
        int targetCateg = 0;
        int factor1Categ = 0;
        int factor2Categ = 0;
        if (result) {
            targetCateg = (int)targetValue;
            factor1Categ = (int)factor1Value;
            factor2Categ = (int)factor2Value;
            boolean bl = result = targetCateg >= 0 && targetCateg < this.nTargetCategs && factor1Categ >= 0 && factor1Categ < this.nFactor1Categs && factor2Categ >= 0 && factor2Categ < this.nFactor2Categs && weight > 0.0;
        }
        if (result) {
            int elemX;
            int cellX = factor1Categ * this.nFactor2Categs + factor2Categ;
            int n = elemX = cellX * this.nTargetCategs + targetCateg;
            this.arrNRecs[n] = this.arrNRecs[n] + weight;
            ++this.validUpdCnt;
            this.totalNRecs += weight;
            this.validNRecs += weight;
        } else {
            ++this.invalidUpdCnt;
            if (weight > 0.0) {
                this.totalNRecs += weight;
            }
        }
        return result;
    }

    @Override
    public boolean merge(AccumStats4InteractTests other) {
        boolean result = other instanceof TwowayLRTestForCategTarget;
        if (!result) {
            return result;
        }
        TwowayLRTestForCategTarget otherL = (TwowayLRTestForCategTarget)other;
        if (otherL.nTargetCategs == 0) {
            return result;
        }
        if (this.nTargetCategs == 0) {
            this.nTargetCategs = otherL.nTargetCategs;
            this.nFactor1Categs = otherL.nFactor1Categs;
            this.nFactor2Categs = otherL.nFactor2Categs;
            this.nCells = otherL.nCells;
            this.targetX = otherL.targetX;
            this.factor1X = otherL.factor1X;
            this.factor2X = otherL.factor2X;
            this.weightX = otherL.weightX;
            this.setNCategs(this.nTargetCategs, this.nFactor1Categs, this.nFactor2Categs);
            MathFun.dCopy((double[])otherL.arrNRecs, (double[])this.arrNRecs);
            if (otherL.nRecsTargetCateg != null) {
                this.nRecsTargetCateg = new double[this.nTargetCategs];
                MathFun.dCopy((double[])otherL.nRecsTargetCateg, (double[])this.nRecsTargetCateg);
            }
            if (otherL.nRecsFactorCateg != null) {
                this.nRecsFactorCateg = new double[this.nCells];
                MathFun.dCopy((double[])otherL.nRecsFactorCateg, (double[])this.nRecsFactorCateg);
            }
            this.validUpdCnt = otherL.validUpdCnt;
            this.invalidUpdCnt = otherL.invalidUpdCnt;
            this.totalNRecs = otherL.totalNRecs;
            this.validNRecs = otherL.validNRecs;
            this.lFull = otherL.lFull;
            this.lReduced = otherL.lReduced;
            this.chiSquare = otherL.chiSquare;
            this.pValue = otherL.pValue;
            this.accuracy = otherL.accuracy;
            this.fitMeasure2 = otherL.fitMeasure2;
            return result;
        }
        if (this.nTargetCategs != otherL.nTargetCategs || this.nFactor1Categs != otherL.nFactor1Categs || this.nCells != otherL.nCells) {
            return false;
        }
        int nAllCells = this.nTargetCategs * this.nCells;
        for (int iCell = 0; iCell < nAllCells; ++iCell) {
            int n = iCell;
            this.arrNRecs[n] = this.arrNRecs[n] + otherL.arrNRecs[iCell];
        }
        this.validUpdCnt += otherL.validUpdCnt;
        this.invalidUpdCnt += otherL.invalidUpdCnt;
        this.validNRecs += otherL.validNRecs;
        this.totalNRecs += otherL.totalNRecs;
        return result;
    }

    @Override
    public boolean merge(List<? extends AccumStats4InteractTests> others) {
        boolean result = true;
        for (int i = 0; result && i < others.size(); ++i) {
            AccumStats4InteractTests other = others.get(i);
            if (other == null) continue;
            result = this.merge(other);
        }
        return result;
    }

    public void setParams4Convergence(int nIterInner, int nIterOuter, double tolInner, double tolOuter) {
        this.maxIterInner = nIterInner;
        this.maxIterOuter = nIterOuter;
        this.tolInner = tolInner;
        this.tolOuter = tolOuter;
    }

    @Override
    public double computeStatistics() {
        double cdf;
        int iFac;
        int elemX;
        double sum;
        if (this.validUpdCnt == 0) {
            return MissingValue.getMissing();
        }
        this.nRecsTargetCateg = new double[this.nTargetCategs];
        this.nRecsFactorCateg = new double[this.nCells];
        int nMissingTargetCateg = 0;
        for (int iTar = 0; iTar < this.nTargetCategs; ++iTar) {
            sum = 0.0;
            elemX = iTar;
            for (int iFac2 = 0; iFac2 < this.nCells; ++iFac2) {
                sum += this.arrNRecs[elemX];
                elemX += this.nTargetCategs;
            }
            this.nRecsTargetCateg[iTar] = sum;
            if (sum != 0.0) continue;
            ++nMissingTargetCateg;
        }
        this.validTargetCateg = new int[this.nTargetCategs - nMissingTargetCateg];
        int i = 0;
        for (int ind = 0; ind < this.nRecsTargetCateg.length; ++ind) {
            if (!(this.nRecsTargetCateg[ind] > 0.0)) continue;
            this.validTargetCateg[i] = ind;
            ++i;
        }
        if (nMissingTargetCateg > 0) {
            this.nTargetCategsAdjusted = this.nTargetCategs - nMissingTargetCateg;
            this.mNRecsAdjusted = new DenseRectMatrix(this.nCells, this.nTargetCategsAdjusted);
            this.mNRecs.extractColumns(this.validTargetCateg, (RectMatrix)this.mNRecsAdjusted);
            this.arrNRecsAdjusted = this.mNRecsAdjusted.getMatrix();
            this.mNRecs = this.mNRecsAdjusted;
            this.arrNRecs = this.mNRecs.getMatrix();
            this.nTargetCategs = this.nTargetCategsAdjusted;
        } else {
            this.nTargetCategsAdjusted = this.nTargetCategs;
            this.mNRecsAdjusted = this.mNRecs;
            this.arrNRecsAdjusted = this.arrNRecs;
        }
        if (this.nTargetCategsAdjusted <= 1) {
            return MissingValue.getMissing();
        }
        DenseRectMatrix mObsProbs = new DenseRectMatrix(this.nCells, this.nTargetCategsAdjusted);
        double[] arrObsProbs = mObsProbs.getMatrix();
        elemX = 0;
        for (iFac = 0; iFac < this.nCells; ++iFac) {
            sum = 0.0;
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                sum += this.arrNRecsAdjusted[elemX++];
            }
            this.nRecsFactorCateg[iFac] = sum;
        }
        elemX = 0;
        for (iFac = 0; iFac < this.nCells; ++iFac) {
            double nRecsFac = this.nRecsFactorCateg[iFac];
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                arrObsProbs[elemX] = nRecsFac > 0.0 ? this.arrNRecsAdjusted[elemX] / nRecsFac : 0.0;
                ++elemX;
            }
        }
        double sumMax = 0.0;
        this.lFull = 0.0;
        elemX = 0;
        for (int iFac3 = 0; iFac3 < this.nCells; ++iFac3) {
            double maxNRecs = 0.0;
            for (int iTar = 0; iTar < this.nTargetCategsAdjusted; ++iTar) {
                double obsProb = arrObsProbs[elemX];
                double nRecs = this.arrNRecsAdjusted[elemX];
                maxNRecs = Math.max(maxNRecs, nRecs);
                if (obsProb > 0.0) {
                    this.lFull += nRecs * Math.log(obsProb);
                }
                ++elemX;
            }
            sumMax += maxNRecs;
        }
        TwowayLRTestLReduced lReducedComp = new TwowayLRTestLReduced(this.mNRecsAdjusted, this.nFactor1Categs, this.nFactor2Categs);
        lReducedComp.setMaxIterInner(this.maxIterInner);
        lReducedComp.setMaxIterOuter(this.maxIterOuter);
        lReducedComp.setTolInner(this.tolInner);
        lReducedComp.setTolOuter(this.tolOuter);
        this.lReduced = lReducedComp.computeLReduced();
        this.lIntercept = 0.0;
        if (this.validNRecs > 0.0) {
            for (int iTar = 0; iTar < this.nRecsTargetCateg.length; ++iTar) {
                double nRecsTar = this.nRecsTargetCateg[iTar];
                if (!(nRecsTar > 0.0)) continue;
                this.lIntercept += nRecsTar * Math.log(nRecsTar / this.validNRecs);
            }
        }
        this.chiSquare = 2.0 * (this.lFull - this.lReduced);
        int nEmpty = 0;
        for (int c = 0; c < this.nRecsFactorCateg.length; ++c) {
            if (this.nRecsFactorCateg[c] != 0.0) continue;
            ++nEmpty;
        }
        double[] sum1 = new double[this.nFactor1Categs];
        double[] sum2 = new double[this.nFactor2Categs];
        for (int cat1 = 0; cat1 < this.nFactor1Categs; ++cat1) {
            int cat2 = 0;
            while (cat2 < this.nFactor2Categs) {
                double nRec = this.nRecsFactorCateg[cat1 * this.nFactor2Categs + cat2];
                int n = cat1;
                sum1[n] = sum1[n] + nRec;
                int n2 = cat2++;
                sum2[n2] = sum2[n2] + nRec;
            }
        }
        int nMissingFactor1Categ = 0;
        for (int cat = 0; cat < this.nFactor1Categs; ++cat) {
            if (sum1[cat] != 0.0) continue;
            ++nMissingFactor1Categ;
        }
        int nMissingFactor2Categ = 0;
        for (int cat = 0; cat < this.nFactor2Categs; ++cat) {
            if (sum2[cat] != 0.0) continue;
            ++nMissingFactor2Categ;
        }
        if (nMissingFactor1Categ > 0 || nMissingFactor2Categ > 0) {
            nEmpty -= nMissingFactor1Categ * this.nFactor2Categs;
            nEmpty -= nMissingFactor2Categ * this.nFactor1Categs;
            nEmpty += nMissingFactor1Categ * nMissingFactor2Categ;
        }
        this.dfEffect = (double)(this.nTargetCategsAdjusted - 1) * (double)((this.nFactor1Categs - nMissingFactor1Categ - 1) * (this.nFactor2Categs - nMissingFactor2Categ - 1) - nEmpty);
        double dfFull = (double)(this.nTargetCategsAdjusted - 1) * (double)((this.nFactor1Categs - nMissingFactor1Categ) * (this.nFactor2Categs - nMissingFactor2Categ) - nEmpty);
        if (this.dfEffect <= 0.0 || dfFull <= 0.0) {
            return MissingValue.getMissing();
        }
        this.pValue = MissingValue.getMissing();
        if (this.dfEffect > 0.0 && !MissingValue.isMissing((double)(cdf = DistributionFunctions.cdfChi((double)this.chiSquare, (double)this.dfEffect)))) {
            this.pValue = 1.0 - cdf;
        }
        this.accuracy = MissingValue.getMissing();
        this.fitMeasure2 = MissingValue.getMissing();
        if (this.validNRecs > 0.0) {
            this.accuracy = sumMax / this.validNRecs;
        }
        if (this.lIntercept != 0.0) {
            this.fitMeasure2 = 1.0 - (this.lFull - dfFull) / this.lIntercept;
            this.effectSize = (this.lReduced - this.lFull + this.dfEffect) / this.lIntercept;
        }
        return this.pValue;
    }

    public Tuple2<Double, Double> computePI(int sampleSize, int randomSeed) {
        double[] probs = this.getObsProbs().getMatrix();
        this.PIPairs = new Tuple2((Object)0.0, (Object)0.0);
        int nCells = this.nCells;
        int nTargCats = this.nTargetCategsAdjusted;
        int nTotalCats = nCells * nTargCats;
        if (this.arrNRecs.length == nTotalCats && probs.length == nTotalCats) {
            int i;
            double totalCaseCount = 0.0;
            double[] cellCounts = new double[nCells];
            double[] totalProb = new double[nTargCats];
            int sampleCaseCount = 0;
            for (int i2 = 0; i2 < nCells; ++i2) {
                cellCounts[i2] = 0.0;
                int j = 0;
                while (j < nTargCats) {
                    int index = j + i2 * nTargCats;
                    totalCaseCount += this.arrNRecs[index];
                    int n = i2;
                    cellCounts[n] = cellCounts[n] + this.arrNRecs[index];
                    int n2 = j++;
                    totalProb[n2] = totalProb[n2] + this.arrNRecs[index];
                }
            }
            int j = 0;
            while (j < nTargCats) {
                int n = j++;
                totalProb[n] = totalProb[n] / totalCaseCount;
            }
            double[] accumSampleCounts = new double[nCells + 1];
            accumSampleCounts[0] = 0.0;
            if ((double)sampleSize > totalCaseCount) {
                for (i = 0; i < nCells; ++i) {
                    accumSampleCounts[i + 1] = accumSampleCounts[i] + cellCounts[i];
                    sampleCaseCount += (int)cellCounts[i];
                }
            } else {
                for (i = 0; i < nCells; ++i) {
                    int num = (int)((double)sampleSize * cellCounts[i] / totalCaseCount);
                    accumSampleCounts[i + 1] = accumSampleCounts[i] + (double)num;
                    sampleCaseCount += num;
                }
            }
            int lVal = 1;
            double[] aveY1Y1 = new double[nTargCats];
            double[] aveY1Y2 = new double[nTargCats];
            double[] aveY1Y3 = new double[nTargCats];
            double[] aveY1Y4 = new double[nTargCats];
            int mode = sampleCaseCount;
            int M = sampleCaseCount / 2;
            Random rng = new Random(randomSeed);
            if (M > 1) {
                while (lVal <= M) {
                    int position1 = rng.nextInt(mode);
                    int index1 = Arrays.binarySearch(accumSampleCounts, (double)(position1 + 1));
                    if (index1 < 0) {
                        index1 = -(index1 + 1) - 1;
                    } else if (index1 > 0) {
                        while (index1 > 0 && accumSampleCounts[index1] == accumSampleCounts[index1 - 1]) {
                            --index1;
                        }
                        --index1;
                    }
                    if (index1 < 0) continue;
                    --mode;
                    int i3 = index1 + 1;
                    while (i3 < accumSampleCounts.length) {
                        int n = i3++;
                        accumSampleCounts[n] = accumSampleCounts[n] - 1.0;
                    }
                    int position2 = rng.nextInt(mode);
                    int index2 = Arrays.binarySearch(accumSampleCounts, (double)(position2 + 1));
                    if (index2 < 0) {
                        index2 = -(index2 + 1) - 1;
                    } else if (index2 > 0) {
                        while (index2 > 0 && accumSampleCounts[index2] == accumSampleCounts[index2 - 1]) {
                            --index2;
                        }
                        --index2;
                    }
                    if (index2 < 0) continue;
                    --mode;
                    int j2 = index2 + 1;
                    while (j2 < accumSampleCounts.length) {
                        int n = j2++;
                        accumSampleCounts[n] = accumSampleCounts[n] - 1.0;
                    }
                    double temp = (double)(lVal - 1) / (double)lVal;
                    int index3 = index1 - index1 % this.nFactor2Categs + index2 % this.nFactor2Categs;
                    int index4 = index2 - index2 % this.nFactor2Categs + index1 % this.nFactor2Categs;
                    for (int k = 0; k < nTargCats; ++k) {
                        int index1k = k + index1 * nTargCats;
                        int index2k = k + index2 * nTargCats;
                        int index3k = k + index3 * nTargCats;
                        int index4k = k + index4 * nTargCats;
                        aveY1Y1[k] = aveY1Y1[k] * temp + probs[index1k] * probs[index1k] / (double)lVal;
                        aveY1Y2[k] = aveY1Y2[k] * temp + probs[index1k] * probs[index2k] / (double)lVal;
                        aveY1Y3[k] = (int)cellCounts[index3] == 0 ? aveY1Y3[k] * temp + probs[index1k] * totalProb[k] / (double)lVal : aveY1Y3[k] * temp + probs[index1k] * probs[index3k] / (double)lVal;
                        aveY1Y4[k] = (int)cellCounts[index4] == 0 ? aveY1Y4[k] * temp + probs[index1k] * totalProb[k] / (double)lVal : aveY1Y4[k] * temp + probs[index1k] * probs[index4k] / (double)lVal;
                    }
                    ++lVal;
                }
                double[] ESquare = new double[nTargCats];
                double[] UX1 = new double[nTargCats];
                double[] UX2 = new double[nTargCats];
                double[] VY = new double[nTargCats];
                double[] SX1 = new double[nTargCats];
                double[] SX2 = new double[nTargCats];
                double temp1 = (double)M / (double)(M - 1);
                double sX1Sum = 0.0;
                double sX2Sum = 0.0;
                for (int k = 0; k < nTargCats; ++k) {
                    ESquare[k] = aveY1Y2[k];
                    UX1[k] = temp1 * aveY1Y3[k];
                    UX2[k] = temp1 * aveY1Y4[k];
                    VY[k] = temp1 * aveY1Y1[k] - ESquare[k];
                    SX1[k] = 0.0;
                    SX2[k] = 0.0;
                    if (!(VY[k] > 0.0)) continue;
                    if (UX1[k] - ESquare[k] >= 0.0) {
                        SX1[k] = (UX1[k] - ESquare[k]) / VY[k];
                        sX1Sum += SX1[k];
                    }
                    if (!(UX2[k] - ESquare[k] >= 0.0)) continue;
                    SX2[k] = (UX2[k] - ESquare[k]) / VY[k];
                    sX2Sum += SX2[k];
                }
                double sumOfSS = sX1Sum + sX2Sum;
                if (sumOfSS > 0.0) {
                    this.PIPairs.first = sX1Sum / sumOfSS;
                    this.PIPairs.second = sX2Sum / sumOfSS;
                }
            }
        }
        return this.PIPairs;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nTargetCategs);
        dataOutput.writeInt(this.nFactor1Categs);
        dataOutput.writeInt(this.nFactor2Categs);
        dataOutput.writeInt(this.targetX);
        dataOutput.writeInt(this.factor1X);
        dataOutput.writeInt(this.factor2X);
        dataOutput.writeInt(this.weightX);
        this.mNRecs.writeObject(dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.nRecsTargetCateg, (DataOutput)dataOutput);
        ACSerializationUtils.writeIntArray((int[])this.validTargetCateg, (DataOutput)dataOutput);
        ACSerializationUtils.writeDoubleArray((double[])this.nRecsFactorCateg, (DataOutput)dataOutput);
        dataOutput.writeInt(this.validUpdCnt);
        dataOutput.writeInt(this.invalidUpdCnt);
        dataOutput.writeDouble(this.validNRecs);
        dataOutput.writeDouble(this.totalNRecs);
        dataOutput.writeDouble(this.lFull);
        dataOutput.writeDouble(this.lReduced);
        dataOutput.writeDouble(this.lIntercept);
        dataOutput.writeDouble(this.chiSquare);
        dataOutput.writeDouble(this.dfEffect);
        dataOutput.writeDouble(this.dfFull);
        dataOutput.writeDouble(this.pValue);
        dataOutput.writeDouble(this.accuracy);
        dataOutput.writeDouble(this.fitMeasure2);
        dataOutput.writeDouble(this.effectSize);
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nTargetCategsAdjusted = this.nTargetCategs = dataInput.readInt();
        this.nFactor1Categs = dataInput.readInt();
        this.nFactor2Categs = dataInput.readInt();
        this.nCells = this.nFactor1Categs * this.nFactor2Categs;
        this.targetX = dataInput.readInt();
        this.factor1X = dataInput.readInt();
        this.factor2X = dataInput.readInt();
        this.weightX = dataInput.readInt();
        this.mNRecs = new DenseRectMatrix(this.nCells, this.nTargetCategs);
        this.mNRecs.readObject(dataInput);
        this.arrNRecs = this.mNRecs.getMatrix();
        this.mNRecsAdjusted = this.mNRecs;
        this.arrNRecsAdjusted = this.arrNRecs;
        this.nRecsTargetCateg = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.validTargetCateg = ACSerializationUtils.readIntArray((DataInput)dataInput);
        this.nRecsFactorCateg = ACSerializationUtils.readDoubleArray((DataInput)dataInput);
        this.validUpdCnt = dataInput.readInt();
        this.invalidUpdCnt = dataInput.readInt();
        this.validNRecs = dataInput.readDouble();
        this.totalNRecs = dataInput.readDouble();
        this.lFull = dataInput.readDouble();
        this.lReduced = dataInput.readDouble();
        this.lIntercept = dataInput.readDouble();
        this.chiSquare = dataInput.readDouble();
        this.dfEffect = dataInput.readDouble();
        this.dfFull = dataInput.readDouble();
        this.pValue = dataInput.readDouble();
        this.accuracy = dataInput.readDouble();
        this.fitMeasure2 = dataInput.readDouble();
        this.effectSize = dataInput.readDouble();
        return this;
    }

    @Override
    public int compareTo(AccumStats4InteractTests o) {
        int ret = 0;
        if (this.accuracy > o.getFitMeasure()) {
            ret = 1;
        } else if (this.accuracy < o.getFitMeasure()) {
            ret = -1;
        } else if (o instanceof AccumTestStats4CatTarget) {
            AccumTestStats4CatTarget ats = (AccumTestStats4CatTarget)o;
            if (this.fitMeasure2 > ats.getMcFaddenR2()) {
                ret = 1;
            } else if (this.fitMeasure2 < ats.getMcFaddenR2()) {
                ret = -1;
            }
        }
        return ret;
    }

    @Override
    public int[] getFactorIndices() {
        int[] result = new int[]{this.factor1X, this.factor2X};
        return result;
    }

    @Override
    public int[] getCovariateIndices() {
        int[] result = null;
        return result;
    }

    @Override
    public double getEffectSize() {
        return this.effectSize;
    }

    @Override
    public double getInterestingness() {
        return this.interestingness;
    }

    @Override
    public void setInterestingness(double val) {
        this.interestingness = val;
    }

    @Override
    public void addMissingCounts(double unweightedMissCount, double weightedMissCount) {
        this.invalidUpdCnt += (int)unweightedMissCount;
        this.totalNRecs += weightedMissCount;
    }
}

